#include <iostream>
#include <math.h>
#include "vuTFPreintegrated.h"

vuTFPreintegrated::vuTFPreintegrated()
{
    m_Table = 0;
    m_Light = 0;
    init(4,256);
};

vuTFPreintegrated::vuTFPreintegrated(dword ncomp, dword range)
{
    m_Table = 0; 
    m_Light = 0;
    init(ncomp,range);
}

vuTFPreintegrated::vuTFPreintegrated(const vuTFIntensity& inst)
{
    m_Table = 0; 
    m_Light = 0;
    init(inst.getNComponents(), inst.getRange());
    operator=(inst);
}

vuTFPreintegrated::~vuTFPreintegrated()
{
    cleanup();
}


vuTFPreintegrated& vuTFPreintegrated::operator=(const vuTFIntensity& rhs)
{
    vuTFIntensity::operator=(rhs);
    preintegrate();

    return *this;
}

void vuTFPreintegrated::preintegrate()
{
    float *pitable = m_PITable;
    float *table = m_Table;
    float alpha = m_Table[m_NComp-1];
    
    if(m_AlphaWeighted)
    {
	for(word c=0; c<m_NComp-1; c++, pitable++, table++)
	{
	    *pitable = (*table)*alpha;
	}
	*pitable = alpha;
	pitable++;
	table++;
	
	for(word i=1; i<m_Range; i++)
	{
	    alpha = table[m_NComp-1];
	    for(word c=0; c<m_NComp-1; c++, pitable++, table++)
	    {
		*pitable = *(pitable-m_NComp) + ((*table) * alpha);
	    }
	    *pitable = *(pitable-m_NComp) + alpha;
	    pitable++;
	    table++;
	}
    } else {
	for(word c=0; c<m_NComp; c++, pitable++, table++)
	{
	    *pitable = (*table);
	}
	
	for(word i=1; i<m_Range; i++)
	{
	    alpha = table[m_NComp-1];
	    for(word c=0; c<m_NComp; c++, pitable++, table++)
	    {
		*pitable = *(pitable-m_NComp) + (*table);
	    }
	}
    }
    // one more entry to avoid conditionals during integration
    for(word c=0; c<m_NComp; c++, pitable++)
    {
	 *pitable = *(pitable-m_NComp);
    }
}

bool vuTFPreintegrated::integrate(float back, float front, float d, vuColourN & col)
{
    if(col.nComponents() != m_NComp) return false;

    word a,b;

    if(front == back)	// limit of averaging integral is value of function at 'front'
    {
	a = (word)floor(front);
	//float alpha = m_Table[a*m_NComp + m_NComp-1];
	//col[m_NComp-1] = alpha;
	
	for(word c = 0; c<m_NComp; c++)
	    col[c] = (m_Table[a*m_NComp + c]);
	//col[m_NComp-1] = 1 - exp(-m_Table[a+m_NComp + m_NComp-1]);
	return true;
    }

//     if(back < front) {		// make a<b
//  	float tmp = front;
//  	front = back;
//  	back = tmp;
// 	//sgnscale = -1;
//     }

    a = (word)floor(front);
    b = (word)floor(back);
    word aind = a*m_NComp;
    word aind2 = aind+m_NComp;
    word bind = b*m_NComp;
    word bind2 = bind+m_NComp;
    
    float fpoint = front-a;
    float omfpoint = 1-fpoint;
    float bpoint = back-b;
    float ombpoint = 1-bpoint;
    
    float ialpha = ((m_PITable[bind2 + m_NComp-1]*bpoint
		     + m_PITable[bind + m_NComp-1]*ombpoint)
		    - (m_PITable[aind2 + m_NComp-1]*fpoint
		       + m_PITable[aind + m_NComp-1]*omfpoint)
		    );
    if(fabs(ialpha)<0.0001)
    {
	for(word c = 0; c<m_NComp; c++)
	    col[c] = 0;
	return true;
    }
    
    float cscale, ascale=1/(back-front);
    if(m_AlphaWeighted)
	cscale = 1/(ialpha);
    else
	cscale = ascale;
    
    for(word c = 0; c<m_NComp-1; c++)
	col[c] = ((m_PITable[bind2 + c]*bpoint
		   + m_PITable[bind+ c]*ombpoint)
		  - (  m_PITable[aind2 + c]*fpoint
		       + m_PITable[aind + c]*omfpoint)
		  )*cscale;
    //col[m_NComp-1] = 1 - exp(-ascale*(aint));
    col[m_NComp-1] = ialpha*ascale;// * (ascale); consider using this
    return true;
}

bool vuTFPreintegrated::init(dword ncomp, dword range)
{
    if(!vuTFIntensity::init(ncomp, range)) return false;
    
    m_PITable = new float[m_TableLength+m_NComp];
    if(!m_PITable) return false;
    
    for (dword i=0;i<m_TableLength+m_NComp;i++)
	m_PITable[i] = 0.0f;
    return true;
}

void vuTFPreintegrated::cleanup()
{
    vuTFIntensity::cleanup();
    if(m_PITable) delete [] m_PITable;
    m_PITable = 0;
}

