#ifndef _VUTFLINEAR_H_
#define _VUTFLINEAR_H_

#include "vuTFIntensity.h"

//!The defines for the four different colour channels.
#define vuTFRed       0x01
#define vuTFGreen     0x02
#define vuTFBlue      0x04
#define vuTFAlpha     0x08

//! A simple linear transfer function.
/*! This transfer function lets you add tents for each of the four
    colour channels (rgb and alpha = opacity).  The tents can be
    given different drop off values, and multiple additions are
    superimposed.
*/

class vuTFLinear : public vuTFIntensity
{
public:
    //!Adds a linear tent to the transfer function.
    /*!\param channels Specify the colour channels to add the tent to.
       \param density The byte density to center the tent on.
       \param width The width of the tent in each direction from the center.
       \param max_value The value of the tent at the center, from 0 to 1.
       \param min_value The value of the tent at the edges, from 0 to 1.
    */
    void addLinear(dword channels,
                   byte density,
                   byte width,
                   float max_value,
                   float min_value);
};

#endif
