#include "simpleFuncs.h"
#include "vuTFLinear.h"

void vuTFLinear::addLinear(dword channels,
                           byte density,
                           byte width,
                           float max_value,
                           float min_value)
{
    float m;
    float b;
    float v;
    byte i;

    m = (max_value-min_value)/(float)width;
    b = max_value - m*((float)density);
    for(i=density-width; i<=density+width; ++i)
    {
        v = m*((float)i)+b;

        if (channels & vuTFRed)
            m_Table[i<<2] = snapToZeroOne(m_Table[i<<2]+v);

        if (channels & vuTFGreen)
            m_Table[(i<<2)+1] = snapToZeroOne(m_Table[(i<<2)+1]+v);

        if (channels & vuTFBlue)
            m_Table[(i<<2)+2] = snapToZeroOne(m_Table[(i<<2)+2]+v);

        if (channels & vuTFAlpha)
            m_Table[(i<<2)+3] = snapToZeroOne(m_Table[(i<<2)+3]+v);

        if (i == density)
        {
            m *= -1.0f;
            b = max_value*2 - b;
        }
    }
}
