#include "vuColour31a.h"
#include "vuColour7a.h"
#include "vuColour9a.h"
#include "vuColourXYZa.h"
#include "vuTFDesignSpec.h"

//#define NORMALIZE_LIGHTS	//normalize lights on initializing palette

//void vuTFDesignSpec::getRGBa(dword i, vuColourRGBa& rgba)
//{
//}

void vuTFDesignSpec::generateFunction()
{
  vuTFDesign::generateFunction();
  // Do own stuff to manipulate the transfer function. Or not.
}

//----------------------------------------------------------------------------
void vuTFDesignSpec::generateOpacities()
{
    dword index;
    //dword numColours = m_Colours.getLength();
    dword numOpacities = m_Opacities.getLength();
    if(false)
    {
	
    }
    
    //First set up the arrays representing the intensity function
    //Note that we always have at least two Nodes
    index = 0;
    for (dword i = 0; i < numOpacities-1; i++)
    {
	float slope = float(m_Opacities[i+1].opacity - m_Opacities[i].opacity) /
	    float(m_Opacities[i+1].intensity - m_Opacities[i].intensity);
	
	for (; index <= m_Opacities[i+1].intensity; index ++)
	    m_Table[index*m_NComp+(m_NComp-1)] = m_Opacities[i].opacity +
		slope * (index-m_Opacities[i].intensity);
    }
    
/*
		opacity = getLightNode(i).col[m_NComp];
		float opacity2 = getLightNode(i+1).col[m_NComp];
		slope = float(opacity2 - opacity) /
		    float(m_Colours[i+1].intensity - m_Colours[i].intensity);
	    } else if(getNumLights()>0)
		opacity = getLightNode(getNumLights()-1).col[m_NComp];
	    
	    for (; index <= m_Colours[i+1].intensity; index ++)
		m_Table[index*m_NComp+(m_NComp-1)] = opacity +
		    slope * (index-m_Colours[i].intensity);
	}
*/
}

//----------------------------------------------------------------------------
//------------------------- public addLight() -------------------------------
//----------------------------------------------------------------------------

dword vuTFDesignSpec::addLight(const float* _col)
{
    //Create the light node
    LightNode cp(0.f,m_NComp,_col);
    
    //Add the new light node.
    m_Lights.add(cp);
    return m_Lights.getLength()-1;
}

//----------------------------------------------------------------------------
//------------------------- public getNumLights -----------------------------
//----------------------------------------------------------------------------

dword vuTFDesignSpec::getNumLights() const
{
    return m_Lights.getLength();
}

//----------------------------------------------------------------------------
//------------------------- public getLightNode() ----------------------------
//----------------------------------------------------------------------------

const vuTFDesignSpec::LightNode& 
vuTFDesignSpec::getLightNode(dword index) const
{
    return m_Lights[index];
}
//----------------------------------------------------------------------------
//------------------------- public setLightWeight() --------------------------
//----------------------------------------------------------------------------

void vuTFDesignSpec::setLightWeight(dword index, float _weight)
{
  m_Lights[index].weight = _weight;
}

//----------------------------------------------------------------------------
//------------------------- public weightLights() ----------------------------
//----------------------------------------------------------------------------

void vuTFDesignSpec::weightLights(const float* weights)
{
  dword llen = getNumLights();
  for(dword l=0;l<llen;l++) {
    setLightWeight(l, weights[l]);
  }
  generateLight();
}

//----------------------------------------------------------------------------
//------------------------- public weightLights() ----------------------------
//----------------------------------------------------------------------------

void vuTFDesignSpec::generateLight()
{
    if(m_NComp == 32) {
	vuColour31a lcol(0.0f);
	dword llen = getNumLights();
	for(dword l=0;l<llen;l++) {
	    vuColour31a lamp(m_Lights[l].col);
	    lamp *= m_Lights[l].weight;
	    lcol += lamp;
	}

	//lcol*= m_LightIntensity/vuColourXYZa(lcol)[1];
	lcol*= m_LightIntensity;
	
	const float *fpc=lcol.getData();
	for(dword c=0;c<32;c++,fpc++)
	    m_Light[c] = *fpc;
	
    } else if(m_NComp == 8) {
	
	vuColour7a lcol(0.0f);
	dword llen = getNumLights();
	for(dword l=0;l<llen;l++) {
	    vuColour7a lamp(m_Lights[l].col);
	    lamp *= m_Lights[l].weight;
	    lcol += lamp;
	}
	for(dword c=0;c<8;c++)
	    m_Light[c] = lcol[c]*m_LightIntensity;
    } else if(m_NComp == 10) {
	vuColour9a lcol(0.0f);
	dword llen = getNumLights();
	for(dword l=0;l<llen;l++) {
	    vuColour9a lamp(m_Lights[l].col);
	    lamp *= m_Lights[l].weight;
	    lcol += lamp;
	}
	for(dword c=0;c<10;c++)
	    m_Light[c] = lcol[c]*m_LightIntensity;
    } else { 
	cout<<"Transfer functions with inherent light sources only supported for 31 and 7 component model."
	    <<endl<<"This transfer function has "<<m_NComp<<" components."<<endl;
    } // add support for other colour models here
}

//----------------------------------------------------------------------------
void vuTFDesignSpec::setLightOpacityNode(word lindex, int intensity)
{
    if(lindex < getNumLights())
    {
	int oind;
	for(oind = int(getNumOpacities())-1;oind>=0;oind--)
	    if(int(m_Opacities[oind].intensity) <= intensity) break;

	if(oind > -1)
	{
	    for(int lind = getNumLights()-1;lind>=0;lind--)
		if(m_Lights[lind].wopade == oind) m_Lights[lind].wopade = -1;
	}
	m_Lights[lindex].wopade = oind;	// -1 will be recognized as disabled
    }
}

//----------------------------------------------------------------------------
void vuTFDesignSpec::setupMtlTriAlphaNodes()
{
    word numOpacities = m_Opacities.getLength();
    word numColours = m_Colours.getLength();
    word nnumOpacities = numColours*3+2;
    if(numOpacities > nnumOpacities) m_Opacities.removeRange(nnumOpacities, numOpacities);
    else
    {
	for(word opac = numOpacities; opac < numColours*3+2; opac++)
	    m_Opacities.insert(m_Opacities.getLength()-2,OpacityNode(0,0));
    }
    
    numOpacities = m_Opacities.getLength();
    //if(numOpacities != nnumOpacities) cout << "rethink setupMtlTriAlphaNodes()"<<endl;

//adjust positions (intensities)
    word lint = 0;
    for(word c = 0; c < numColours; c++)
    {
	word cind = 1+3*c;
	word nint = m_Colours[c].intensity;
	word cint = (lint+nint)/2;
	
	//word nint = (c<numColours-1) ? m_Colours[c+1].intensity : m_Range-1;
	word tmpint  = word(0.9*lint + 0.1*cint);
	if(tmpint == lint) tmpint++;
	m_Opacities[cind].intensity = tmpint;
	m_Opacities[cind+1].intensity = cint;
	tmpint  = word(0.1*cint + 0.9*nint);
	if(tmpint == nint) tmpint--;
	m_Opacities[cind+2].intensity = word(tmpint);
	lint = m_Colours[c].intensity;
    }
    m_Opacities[numOpacities-1].intensity = m_Range-1;
}

//----------------------------------------------------------------------------
void vuTFDesignSpec::setAlphaByLight()
{
    word numOpacities = m_Opacities.getLength();
    word numLights = m_Lights.getLength();
    /* // old automatic choice of nodes (now user controlled)
    word numColours = m_Colours.getLength();
    word nnumOpacities = numColours*3+2;
    if(nnumOpacities != numOpacities) {
	cout << "number of opacity nodes doesn't fit.";
	return;
    }
    word numAlphaNodes = numLights<numColours ? numLights : numColours;
    for(word l=0;l<numAlphaNodes; l++)
    {
	m_Opacities[1+l*3+1].opacity = m_Lights[l].weight;
    }
    */
    for(word l=0;l<numLights;l++)
    {
	int oind = m_Lights[l].wopade;
	if(oind >= 0 && oind<numOpacities)
	    m_Opacities[oind].opacity = m_Lights[l].weight;
    }
    
}

//----------------------------------------------------------------------------
// functions for saving

void vuTFDesignSpec::writeTFunc(ofstream &ofp) const
{
    writeNComp(ofp);
    writeOpacities(ofp);
    writeColours(ofp);
    writeLights(ofp);
}

bool vuTFDesignSpec::writeLights(ofstream &ofp) const
{
  //lights
  word ncol = getNumLights();
  for(dword o=0;o<ncol;o++) {
    ofp<<"light(";
    for(dword c=0;c<m_NComp-1;c++) {
      if(c)ofp<<", ";
      ofp<<getLightNode(o).col[c];
    }
    ofp<<")"<<endl<<endl;
  }
  return true;
}

void vuTFDesignSpec::clearAllNodes()
{
    m_Lights.removeRange(0,m_Lights.getLength());
    vuTFDesign::clearAllNodes();
}


//----------------------------------------------------------------------------
// functions for the parser

void vuTFDesignSpec::parseTFunc()
{
  clearAllNodes();
  
  bool read = true;
  while (read) {
    read = false;
    if ( readOpacity() ) { read = true; }
    else if ( readColour() ) { read = true; }
    else if ( readLight() ) { read = true; }
    else if ( readNComp() ) { read = true; };
  }
  //if(m_NComp>4) setupMtlTriAlphaNodes();
  m_Palette.reset();
  updatePalette();
}

//----------------------------------------------------------------------------
bool vuTFDesignSpec::readLight()
{
  if( readString("light") ) {
    float col[32];
    if(!readNumber(" ( ",col[0])) throw "Error reading light.";
    bool read = true;
    dword c = 1;
    while (read && c<32) {
      read = false;
      if(readNumber(" , ",col[c])) {
	read = true;
	c++;
      } else if(readString(" ) ")) read = false;
    }
    if(c==32) readString(" ) ");
    else if(c==0) throw "Error reading light components";
    while(c<32) col[c++] = 0.0f;
    addLight(col);
    return true;
  } else return false;
}

//----------------------------------------------------------------------------
/** sets entries in palette according to lights and materials in transfer func. */
void vuTFDesignSpec::updatePalette()
{
    while(m_Palette.getNLights() < getNumLights())
		m_Palette.addLight(vuColour31a());
    while(m_Palette.getNRefls() < getNumColours())
		m_Palette.addReflectance(vuColour31a());
    
    for(dword i=0;i<getNumLights() && i<m_Palette.getNLights();i++)
    {
		vuColour31a light(m_Lights[i].col);
#ifdef NORMALIZE_LIGHTS		//we shouldn't do that
		light /= SVector(light).norm();
#endif
		m_Palette.getSpec(-1,i) = light;
    }

    for(dword i=0;i<getNumColours() && i<m_Palette.getNRefls();i++)
		m_Palette.getSpec(i,-1) = vuColour31a(m_Colours[i].col);

    m_Palette.matchDesignColours();
}

//----------------------------------------------------------------------------
/** sets materials and lights in transfer function from values in palette */
void vuTFDesignSpec::updateFromPalette()
{
    for(dword i=0;i<m_Palette.getNLights();i++)
    {
		if(i<getNumLights())
			memcpy(m_Lights[i].col,m_Palette.getSpec(-1,i).getData(),
				   sizeof(float)*31);
		else{
			addLight(m_Palette.getSpec(-1,i).getData());
		}
    }
    
    for(dword i=0;i<m_Palette.getNRefls() && i<getNumColours();i++)
    {
		memcpy(m_Colours[i].col,m_Palette.getSpec(i,-1).getData(),
			   sizeof(float)*31);
    }
}

//----------------------------------------------------------------------------







