/*	Modified April 2002
	Modified by Christopher Steinbach

	Modified to remove the ios::nocreate flag in the
	SGI-IRIX compile because it doesn't seem to be
	available for the SGIs

	Modifed to work with the key framer dialog box.

	Added drawpic and get camera and get image;
*/

#ifndef _VUVOLUMEREGULARUNIMODAL3D1B1VALSPLAT_H_
#define _VUVOLUMEREGULARUNIMODAL3D1B1VALSPLAT_H_

#include "../intensity.h"
#include "glos.h"

#include <GL/gl.h>
#include <GL/glu.h>

#include "vuImage.h"
#include "vuSimpleTypes.h"
#include "vuNormalTable.h"
#include "vuVector.h"

//using namespace ns_vu1112113;

class vu1112111;
typedef vu1112111 vuVolumeRegularUnimodal3d1B1ValSplat;

//!Implements a general splatter for this leaf of the tree.
/*!This class renders the volume using a general splatting method. The
   point of this splatter is to provide a general viewer that can be
   used for all purposes.  The most efficient splatters change the volume
   data to speed up rendering, and therefore cannot be used with multiple
   transfer functions.  The function of this splatter is to leave the
   volume data as is, while rendering as fast as possible.  This allows
   users to apply different transfer functions, and to write and look at
   the data after rendering it.

 \todo
    Find some way to add the ios::nocreate flag or some equivalent to this code
    so that we have similar behaviour in IRIX as we do Linux or Windows.
*/
class vu1112111 : public vu111211

{
public:
    //!Default constructor creating an empty instance.
    vu1112111();
    //!Copy constructor which does a deep copy.
    vu1112111(const vu1112111& inst);
    //!Destructor.
    virtual ~vu1112111();

    //!Assignment operator which does a deep copy.
    vu1112111& operator=(const vu1112111& rhs);

public:
    //!Sets the camera viewing position for the render method.
    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

    //!Sets the size of the splatting footprint.
    void setFootprintSize(dword size);
    //!Returns the size of the splatting footprint
    dword getFootprintSize() const;

    //!Initializes open gl for rendering the volume data.
    void initOpenGL(void);
    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    void drawPic ();

    vuImage* getBuffer ();
//    void setBufferSize ();

    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();

    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

private:
    //!Preprocesses volume data for rendering once it's been read.
    void preprocess(void);

    //!Compute the splatting texture.
    void computeSplat(void);
    //!Computes splatting values using the Nelson algorithm.
    double nelsonSplat(double r);

    //!Draws a splat at the given position using orthogonal view
    void drawSplatOrtho(float* pos);
    //!Draws a splat at the given position using perspective view
    void drawSplatPerspective(float* pos);

private:
    vuNormalTable  m_NTable;

#if defined(QUANTIZE_NORMALS)
    byte*        m_Normals;
#else
    float*       m_Normals;
#endif

    vuImage      m_ImgBuffer;

    GLubyte*     m_Footprint;
    dword        m_FPSize;
    GLuint       m_GLSplat;

    vuVector     m_View;
    vuVector     m_Shift0;
    vuVector     m_Shift1;
    vuVector     m_Shift2;
};

#endif



