#include <iostream>
#include <stdio.h>
#include <math.h>

#include "vuVector.h"

//g++ gensphere.cpp -o gensphere -I ~/space/projects/vuVolume/proj/General ~/space/projects/vuVolume/proj/General/vuVector.o

#define MAXX	45
#define MAXY	45
#define MAXZ	90
#define DATSIZE	MAXX*MAXY*MAXZ
#define FNAME	"sphere.bcc.vud"
#define T	1.41421356

// taken from vu1512
vuVector getVoxelPosition(int x, int y, int z)
{
  vuVector pos;
  if(z&0x01){
    //secondary grid
    pos[0] = (float(x)+0.5)*T;
    pos[1] = (float(y)+0.5)*T;
    pos[2] = (float(z))*(T*0.5);
  } else {
    //primary grid
    pos[0] = float(x)*T;
    pos[1] = float(y)*T;
    pos[2] = float(z)*T*0.5;
  }

  return pos;
}


void main(void)
{
  FILE *f = fopen(FNAME,"wb");
  if(f) {
    fprintf(f,"# vu DataFile Version 1.0\n");
    fprintf(f,"Volume Data\n");
    fprintf(f,"BINARY\n");
    fprintf(f,"DATASET BCC_POINTS\n");
    fprintf(f,"UNIMODAL\n");
    fprintf(f,"DIMENSIONS %i %i %i 1\n",MAXX,MAXY,MAXZ);
    fprintf(f,"ORIGIN 0 0 0 0\n");
    fprintf(f,"SPACING 0 0 0 0\n");
    fprintf(f,"POINT_DATA %i\n",DATSIZE);
    fprintf(f,"SCALARS data byte\n");
    fprintf(f,"LOOKUP_TABLE default\n");

    vuVector center = getVoxelPosition(MAXX,MAXY,MAXZ)*0.5f;
    float radius = center[center.getDominantAxis()]*0.8f;
    int i,j,k;
    for(k=0;k<MAXZ;k++) {
      for(j=0;j<MAXY;j++) {
	for(i=0;i<MAXX;i++) {
	  vuVector pos = getVoxelPosition(i,j,k);
	  vuVector v = pos-center;
	  float dist = v.norm();
	  if(dist<radius) {
	    float t = (radius-dist)/radius;
	    unsigned char val = (unsigned char)(t*255 + (1-t)*100);
	    fputc(val,f);
	  } else if(fabs(v[v.getDominantAxis()])<radius)
	    fputc(50,f);
	  else
	    fputc(0,f);
	}
      }
    }
    fclose(f);
  } else printf("Couldn't create file %s.\n",FNAME);

}
