//
// File:   Util.h
// Author: Steve Kilthau
// Date:   August, 1999
// 
// This file defines several utility functions
// used in other parts of the program.
//

// Modifications by Steven Bergner, Aug 2001
// This file does not need any documentation ;-)

#ifndef _UTIL_H_
#define _UTIL_H_

#include <math.h>
#include "vuVector.h"
#include "vuColourRGBa.h"
#include "vuColourXYZa.h"
#include "vuColour31a.h"
#include "vuColour7a.h"
#include "vuColour9a.h"


#define DEG2RAD    0.01745329251994  // PI/180
#define SNAP_TOLERANCE  0.0000001
#define D65_NORMAL 1056.442   // D65 Normalizing luminance


#define DO_POST_CLASSIFICATION
#define USE_VUTFUNC

//#define USE_RGBA
//#define USE_SPECTRUM31A
#define USE_SPECTRUM7A
//#define USE_SPECTRUM9A

#if defined USE_RGBA
    typedef vuColourRGBa ColourType;
#elif defined USE_SPECTRUM31A
    typedef vuColour31a ColourType;
#elif defined USE_SPECTRUM7A
    typedef vuColour7a ColourType;
#elif defined USE_SPECTRUM9A
    typedef vuColour9a ColourType;
#endif


#ifndef Min
#define Min(a,b)	(a<b ? a : b)
#endif
#ifndef Max
#define Max(a,b)	(a>b ? a : b)
#endif
#ifndef Sgn
#define Sgn(a)		(a>0 ? 1 : a<0 ? -1 : 0)
#endif

namespace ns_vu1112112 {
using namespace ns_vu1112112;


// Check if value is within TOLERANCE of zero.  If it
// is then make value equal to zero.
float SnapToZero(float t);


// Swap the values of two items.
template<class T>
void Swap(T& t1, T& t2)
{
    T t(t1);
    t1 = t2;
    t2 = t;
}

} // end of namespace

#endif
