
#ifndef _SPECTRALIMAGE_H_
#define _SPECTRALIMAGE_H_

#include "Util.h"

namespace ns_vu1112112 {
using namespace ns_vu1112112;


/** Hold a spectrum for each pixel on the screen. 
    Is used to apply post-illumination.
    The reference to ColourType is a typecast that stands for 
    the color model used in the currently compiled version.
   \todo relate it more to the framebuffer provided by a future version
   of vuDrawTools
 */
class SpectralImage  
{
public:
        /** \return light source currently used for illumination */
	const ColourType& get_light() const;
	/** get colour from specific point 
	    \return false if xy out of range */
	bool get_xy(int x, int y, ColourType & col);
	/** get extents of image */
	void get_extents(int & sizx, int & sizy);
	/** initialize spectral framebuffer of given size
	    \todo meaningful concept for framebuffer resize */
	bool init(int sizx, int sizy);
	/** set a specific light source 
	    this source is used to apply post illumination */
	void set_light(ColourType light);
	/** performs post illumination
	    This functions applies the light source given by set_light()
	    and transforms the resulting colors to RGB which is written
	    into the buffer.
	    \param buf pointer to byte buffer
	    \param size of buffer in byte (unsigned char)
	    \return if(buf == NULL || size<3*maxx*maxy) return false */
	bool get_rgb(byte *buf, int size) const;

	/** set spectral color information for a point */
	bool set_xy(int x, int y, const ColourType col) {
	    if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	    spix[x+maxx*y] = col;
	    return true;
	}
	/** constructor */
	SpectralImage();
	/** destructor */
	virtual ~SpectralImage();
	/** set mask to value */
	void set_mask(bool value=true);
	/** create a mask to deactivate all pixels with a zero spectrum */
	void create_black_mask();
private:
	/** stores the light source */
	ColourType light;
	/** pointer to spectral frame buffer */
	ColourType *spix;
	/** mask to avoid calculating black points */
	bool *mask;
	/** extents of the framebuffer */
	int maxx,maxy;
};

} // end of namespace
#endif
