// SpectralImage.cpp: Implementierung der Klasse SpectralImage.
//
//////////////////////////////////////////////////////////////////////
#include <stddef.h>
#include "SpectralImage.h"

namespace ns_vu1112112 {
using namespace ns_vu1112112;


//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

SpectralImage::SpectralImage()
{
  spix = NULL;
  mask = NULL;
  maxx = maxy = 0;
  init(0,0);
}

SpectralImage::~SpectralImage()
{
    if(spix) delete [] spix;
    spix = NULL;
    if(mask) delete [] mask;
    mask = NULL;
}

bool SpectralImage::init(int sizx, int sizy)
{
    if(maxx != sizx || maxy != sizy) {
	maxx=sizx;
	maxy=sizy;
	if(spix) delete [] spix;
	if(mask) delete [] mask;
	if(sizx && sizy)
	{
	    spix = new ColourType[maxx*maxy];
	    if(!spix) return false;
	    mask = new bool[maxx*maxy];
	    if(!mask) return false;
	}
    }
    if(sizx && sizy)
    {
	int i;
	for(i=0; i<maxx*maxy; i++)
	    spix[i] = 0.0f;
	set_mask(false);
    } else { spix = NULL; mask = NULL; }
    return true;
}

void SpectralImage::set_mask(bool value)
{
    int i;
    for(i=0; i<maxx*maxy; i++)
	mask[i] = 0;
}

void SpectralImage::create_black_mask()
{
    int i;
    for(i=0; i<maxx*maxy; i++)
	mask[i] = spix[i].maxComponent()>0.00001f;
}

bool SpectralImage::get_rgb(byte *buf, int size) const
{
  int sizeXY = maxx*maxy;
  if(spix == NULL || buf == NULL || size<3*sizeXY) return false;
  vuColourXYZa xyza;
  vuColourRGBa rgba;
  const ColourType *spec = spix;
  //xyza.setNormalSpectrum(vuColour31a(ambient)); //HERE-- fixed scaling
  int i;
  for(i=0;i<sizeXY;i++, spec++)
  {
      if(mask[i]) {
#if defined USE_RGBA
	  ColourType col(*spec);
	  col*=light;
	//            col.clampTo1();
	//			rgba = col;
	//*
	  xyza.From(col);
	  //            xyza.normalize();		// normalization darkens too much...
	  rgba.from(xyza);
	  rgba.clampTo1();
	  //*/
#elif defined USE_SPECTRUM9A
	  (vuColour9a(spix[x+maxx*y]*light)).to(rgba);
	  rgba.clampTo01();
#else	//if 31a or 7a
	//xyza.from(spix[x+maxx*y]*light);
	//xyza.normalize();   // Do I do this here??
	//rgba.from(xyza);
	  rgba.from(*spec*light);
	  rgba.clampTo01();
#endif
	  *(buf++)=(unsigned char)(255.f*rgba[0]);
	  *(buf++)=(unsigned char)(255.f*rgba[1]);
	  *(buf++)=(unsigned char)(255.f*rgba[2]);
      } else {
	  *(buf++)= 0; *(buf++)= 0; *(buf++)= 0;
      }
  }
  return true;
}

void SpectralImage::set_light(ColourType light)
{
	this->light = light;
}


void SpectralImage::get_extents(int &sizx, int &sizy)
{
	sizx=maxx;
	sizy=maxy;
}

const ColourType& SpectralImage::get_light() const
{
	return light;
}

} // end of namespace
