// Material.h

#ifndef _MATERIAL_H_
#define _MATERIAL_H_

#include "Util.h"
#define MAT_NUM_MATERIALS	3

namespace ns_vu1112112 {
using namespace ns_vu1112112;

/** Describes spectral properties of a material.
    Scattering describes which amount of light is reflected omnidirectionally.
    The absorption is treated like a seperate alpha value for each channel.*/
class Material  
{
public:
  /** constructor */
    Material();
    /** destructor */
    virtual ~Material();

    /** assignment operator */
    Material& operator=(const Material& mat);

    /** if absorption spectrum is flat an internal flag flat_absorption is set. */
    void check_absorption();

    //! weights for the illuminating spectrum
    ColourType  absorption;			//! tells what is transmitted?
    ColourType	scattering;			//! tells what is scattered?

    /** If true material doesn't absorbe light but will still scatter.
	That means intensities along the ray will just add up, which results in
	x-ray like images */
    bool xray;
    
    //! this flag simpilies absorption calculation if absorption has a flat spectrum
    bool flat_absorption;
    //! low intensity thresholds for matierial
    /*! The two limits make up an interval for a tent classification function.
        in the middle the material percentage is 100% decreasing linearly to 
        the borders down to 0%. 
	They should be chosen in a way that no materials overlap to make up
	more than 100% this would brighten up the voxels. 
    */
    int low_th;
    int high_th;
};

} // end of namespace
#endif

