// Material.cpp: Implementierung der Klasse Material.
//
//////////////////////////////////////////////////////////////////////

#include "iostream.h"
#include "Material.h"

namespace ns_vu1112112 {
using namespace ns_vu1112112;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

Material::Material()
{
  low_th=0;
  high_th=255;
  flat_absorption = false;
  xray = false;
}

Material::~Material()
{

}

Material& Material::operator=(const Material& mat)
{
    absorption = mat.absorption;
    scattering = mat.scattering;
    xray = mat.xray;
    low_th = mat.low_th;
    high_th = mat.high_th;
    flat_absorption = mat.flat_absorption;
    return *this;
}

void Material::check_absorption()
{
    if(absorption.maxComponent() == absorption.minComponent())
    {
	flat_absorption = true;
	if(xray) cout<< "X-ray material"<<endl;
	
    }
    else
	flat_absorption = false;
}

} // end of namespace
