// DatPnt.h: Schnittstelle fr die Klasse DatPnt.
//
//////////////////////////////////////////////////////////////////////
#ifndef _DATPNT_H_
#define _DATPNT_H_

#include "Util.h"
#include "Material.h"

namespace ns_vu1112112 {
using namespace ns_vu1112112;

class vu1112112;

/** Class containing information about a single grid point. 
    Instances of this class are managed inside the according geometry by DatGrid.
*/
class DatPnt  
{
public:
    enum Flags {Invisible=0, Visible=1, SkipCell=2};

        /** shade the point according to the information contained in the render engine r. */
        void shade(vu1112112 &r);
        /** classify the point according to the information contained in the render engine r. */
        void classify(vu1112112 &r);
	/** reset class information */
	void reset();
	/** constructor */
	DatPnt();
	/** destructor */
	~DatPnt();

	//!set the flag
	void setFlag(Flags vflag) { flag=(char)vflag;};
	//!get the flag
	Flags getFlag() { return (Flags)flag; }

	//char m_Data[20];
	/** the data byte for the point  
	    it would be better to refer to the original dataset. But for the current
	    implementation a reference would take more time. */
	unsigned char		data;
	//! flag to tag unused voxels
	char			flag;
	/** original length of gradient
	    if it's > 255 it will be clamped ;-) */
	unsigned char		length;
 //! gradient from central differences normalized to length 128
	signed char		grad[3];
#ifndef DO_POST_CLASSIFICATION
	float			density[MAT_NUM_MATERIALS]; //!< material percentages, summarized <1
#endif
	float			illum;	 //!< the point is illuminated by a white spectrum
//	ColourType		illum;   - no illuminating spectrum
};

} // end of namespace
#endif
