// DatPnt.cpp: Implementierung der Klasse DatPnt.
//
//////////////////////////////////////////////////////////////////////

#include "spectral.h"
#include "DatPnt.h"
#include "vuSampleRay.h"


namespace ns_vu1112112 {
using namespace ns_vu1112112;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

DatPnt::DatPnt()
{
	reset();
}

DatPnt::~DatPnt()
{
	
}

void DatPnt::reset()
{
	illum=0;
	flag =0;
#ifndef DO_POST_CLASSIFICATION
	int i;
	for(i=0;i<MAT_NUM_MATERIALS;i++)
		density[i]=0;
#endif
}

void DatPnt::shade(vu1112112 &r)
{
    //take dot product with the light direction and normalize by 128
	float ndotl = (float)(grad[0]*r.m_LightDir[0]+
			      grad[1]*r.m_LightDir[1]+
			      grad[2]*r.m_LightDir[2])/(1<<7);
	if(ndotl<0) ndotl=0;
	illum = ndotl*r.diffuse+r.brightness;

// some mislead approach to weight influence of gradient lenght and intensity
//	int v = len*4;
//	if(v>255) v= 255;
//	v=(data*v/255);
//	v=(v+255)/2;

}

void DatPnt::classify(vu1112112 &r)
{
#ifndef DO_POST_CLASSIFICATION
	int m;
	for(m=0;m<r.nummat;m++)
	{
		if (data>r.mat[m].low_th &&
			data<=r.mat[m].high_th  )
		{
			int d =((r.mat[m].high_th + r.mat[m].low_th)>>1)-data;
			density[m] = (.5f-(float)fabs((float) d/
						      (r.mat[m].high_th
						       -r.mat[m].low_th)))*2.f;
		}		// maybe we apply other distributions here
		else density[m] = 0.f;
	}
#elif defined (USE_VUTFUNC)
// do a minimum of pre-classification to determine visibility
// use currently set transfer function
	ColourType emissive(r.m_TFunc[data]);
	
	float alpha = emissive.getAlpha();
	if(alpha < 0.001)
	    setFlag(Invisible);
	else
	    setFlag(Visible);
#else
	setFlag(Visible);
#endif
}

} // end of namespace
