// DatGrid.h
//
//////////////////////////////////////////////////////////////////////

#ifndef _SPECTRAL_DATGRID_H_
#define _SPECTRAL_DATGRID_H_

#include "Util.h"
#include "DatPnt.h"

namespace ns_vu1112112 {
using namespace ns_vu1112112;

class vuSampleRay;
class vu1112112;

/** This is an indexed collection of DatPnt instances.
    Provides functions related to the volume data including 
    indexing, normal calculation, classification, clipping a vuRay 
    (as vuSampleRay) to the bounding box, and aquiring interpolated
    sampling points advancing this ray.
*/
class DatGrid  
{
  friend class vuSampleRay;
public:
        /** Calulates the gradients using central differencing. */
	void calculate_gradients();
	/** perform shading for each grid point.
	    calls DatPnt::shade() */
	void shade(vu1112112 &r);
	/** perform pre-classification for each grid point.
	    calls DatPnt::classify(), plus checks visibility of 
	    cells. */
	void classify(vu1112112 &r);
	/** loads a volume into the grid structure.
	    Does not do any further preprocessing steps. */
	bool load_vol(byte* data, vu1112112 &r);
	/** Creates a sphere into a given bounding volume. */
	void createSphere();
	/** prepares the memory for a data set of given size */
	int init(int maxx, int maxy, int maxz);
	
	/** constructor */
	DatGrid();
	/** destructor */
	~DatGrid();

 protected:
	/** get the memory for the set up size */
	int get_vol_mem();
	/** free the memory */
	int free_vol_mem();

	int maxX, maxY, maxZ;			//!< extents along each axis
	int layXY;				//!< size of x-y slice
	int size;				//!< total number of points in grid

	void distributeIllum(ColourType &il);

	DatPnt	*vol;			// linear array for the grid points

private:
	float clipRay(vuSampleRay &r, bool bidirectional, int& m_Side) const;

	vuVector m_C0;		// The smaller corner of the cube
	vuVector m_C1;		// The larger corner of the cube
};

} // end of namespace
#endif

