/*	Written by Steven Bergner...

	Modified June 2002
	Modified by Christopher Steinbach
	Modified to work with the keyframe animator.
*/

#ifndef _VUVOLUMEREGULARUNIMODAL3D1B1VALSPECSPLAT_H_
#define _VUVOLUMEREGULARUNIMODAL3D1B1VALSPECSPLAT_H_

#include "../intensity.h"

//!!! This is just a hack. It's not meant to stay in here...
// But anyways, we'll have to find a way to handle non-NVidia Environments.
#include <GL/gl.h>
//#include "glnv.h"

#include "glos.h"
#include <GL/glu.h>
#include "vuSimpleTypes.h"
#include "vuNormalTable.h"
#include "vuTFunc/vuTFDesignSpec.h"
#include "vuColour7a.h"
#include "vuVector.h"

#include "vuImage.h"

class vu1112115;
typedef vu1112115 vuVolumeRegularUnimodal3d1B1ValSpecSplat;

//!Implements a splatter using a spectral colour model
/*!
*/
class vu1112115 : public vu111211
{
public:
    //!Default constructor creating an empty instance.
    vu1112115();
    //!Copy constructor which does a deep copy.
    vu1112115(const vu1112115& inst);
    //!Destructor.
    virtual ~vu1112115();

    //!Assignment operator which does a deep copy.
    vu1112115& operator=(const vu1112115& rhs);

    void drawPic ();
    vuImage* getBuffer ();

public:
    //!Sets the camera viewing position for the render method.
    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

    //!Sets the size of the splatting footprint.
    void setFootprintSize(dword size);
    //!Returns the size of the splatting footprint
    dword getFootprintSize() const;

    //!Initializes open gl for rendering the volume data.
    void initOpenGL(void);
    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();

    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

private:
    //!Preprocesses volume data for rendering once it's been read.
    void preprocess(void);

    //!Compute the splatting texture.
    void computeSplat(void);
    //!Computes splatting values using the Nelson algorithm.
    double nelsonSplat(double r);

    //!Draws a splat at the given position using orthogonal view
    void drawSplatOrtho(float* pos);
    //!Draws a splat at the given position using perspective view
    void drawSplatPerspective(float* pos);

    void initVertexProgram();

    void setCXFMatrix(float* m);

    void setColour7a(const float* col);
    void setLightColour (vuColour7a &);
    void setLightPosition (vuVector & v);

private:
    vuNormalTable  m_NTable;
#if defined(QUANTIZE_NORMALS)
    byte*        m_Normals;
#else
    float*       m_Normals;
#endif

    vuImage 	m_ImgBuffer;

    GLubyte*     m_Footprint;
    dword        m_FPSize;
    GLuint       m_GLSplat;

    vuVector     m_View;
    vuVector     m_Shift0;
    vuVector     m_Shift1;
    vuVector     m_Shift2;
};

#endif
