#include <fstream.h>
#include <math.h>
#include <string>

#include "vuColourRGBa.h"

#include "specsplat.h"

//----------------------------------------------------------------------------
//------------------------- Static texture variables -------------------------
//----------------------------------------------------------------------------

	// not used in the code.
//static float texcoord0[2] = {0.0f, 0.0f};
//static float texcoord1[2] = {0.0f, 1.0f};
//static float texcoord2[2] = {1.0f, 1.0f};
//static float texcoord3[2] = {1.0f, 0.0f};

//
// C0..C3 modelview matrix
// C4..C7 projection matrix
// C8..C11 modelview inverse transpose matrix
// C12 light position
// C13..c14 light colour
// C15..17..20 left and right half of light transform matrix (3x8)
static const unsigned char g_OneLight__[] =
{
"!!VP1.0 \
MOV R4, v[COL0];\
MOV R5, v[COL1];\
MUL R4, R4, c[13];\
MUL R5, R5, c[14];\
DP4 R6.x, c[15], R4;\
DP4 R7.x, c[16], R5;\
DP4 R6.y, c[17], R4;\
DP4 R7.y, c[18], R5;\
DP4 R6.z, c[19], R4;\
DP4 R7.z, c[20], R5;\
MOV R7.w, v[COL1].w;\
ADD o[COL0], R7, R6;\
MOV o[TEX0], v[TEX0];\
END"
};

static const unsigned char g_OneLight[] = 
{
"!!VP1.0 \
DP4 R0.x, v[OPOS], c[0];\
DP4 R0.y, v[OPOS], c[1];\
DP4 R0.z, v[OPOS], c[2];\
DP4 R0.w, v[OPOS], c[3];\
DP4 o[HPOS].x, R0, c[4];\
DP4 o[HPOS].y, R0, c[5];\
DP4 o[HPOS].z, R0, c[6];\
DP4 o[HPOS].w, R0, c[7];\
DP3 R1.x, v[NRML], c[8];\
DP3 R1.y, v[NRML], c[9];\
DP3 R1.z, v[NRML], c[10];\
ADD R2, c[12], -R0;\
DP3 R2.w, R2, R2;\
RSQ R2.w, R2.w;\
MUL R2, R2, R2.w;\
DP3 R3, R1, R2;\
MUL R4, v[COL0], R3;\
MUL R5, v[COL1], R3;\
MUL R4, R4, c[13];\
MUL R5, R5, c[14];\
DP4 R6.x, c[15], R4;\
DP4 R7.x, c[16], R5;\
DP4 R6.y, c[17], R4;\
DP4 R7.y, c[18], R5;\
DP4 R6.z, c[19], R4;\
DP4 R7.z, c[20], R5;\
MOV R7.w, v[COL1].w;\
ADD o[COL0], R7, R6;\
MOV o[TEX0], v[TEX0];\
END"
};

//----------------------------------------------------------------------------
//------------------------- The default constructor --------------------------
//----------------------------------------------------------------------------

vu1112115::vu1112115()
{
    m_Normals = 0;

    m_FPSize    = 256;
    m_Footprint = 0;
    m_GLSplat   = 0;

    m_TFunc.resize(8,256);

    computeSplat();
}

//----------------------------------------------------------------------------
//------------------------- The copy constructor -----------------------------
//----------------------------------------------------------------------------

vu1112115::vu1112115(const vu1112115& inst) : vu111211(inst)
{
    dword i;

    m_NTable = inst.m_NTable;

#if defined(QUANTIZE_NORMALS)
    m_Normals = new byte[m_DataSize];
#else
    m_Normals = new float[m_DataSize*3];
#endif
    for(i=0;i<m_DataSize;++i)
        m_Normals[i] = inst.m_Normals[i];

    m_TFunc.resize(8,256);

    m_FPSize = inst.m_FPSize;
    computeSplat();
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vu1112115::~vu1112115()
{
    if (m_Normals)
        delete [] m_Normals;
    if (m_Footprint)
    {
        delete [] m_Footprint;
//NVCOMMENT        glDeleteTextures(1, &m_GLSplat);
    }
}

//----------------------------------------------------------------------------
//------------------------- The assignment operator --------------------------
//----------------------------------------------------------------------------

vu1112115& vu1112115::operator=(const vu1112115& rhs)
{
    if (this != &rhs)
    {
        vu111211::operator=(rhs);

        dword i;

        m_NTable = rhs.m_NTable;

        if (m_Normals)
            delete [] m_Normals;

#if defined(QUANTIZE_NORMALS)
        m_Normals = new byte[m_DataSize];
#else
        m_Normals = new float[m_DataSize*3];
#endif
        for(i=0;i<m_DataSize;++i)
            m_Normals[i] = rhs.m_Normals[i];

        m_FPSize = rhs.m_FPSize;

        computeSplat();
    }
    return *this;
}

//----------------------------------------------------------------------------
//------------------------- public setViewVectors() --------------------------
//----------------------------------------------------------------------------

void vu1112115::setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right)
{
    m_View = view;
    m_Shift1 = right*3.2f;
    m_Shift2 = up*3.2f;
    m_Shift0 = (m_Shift1+m_Shift2)*(-0.5f);
}

//----------------------------------------------------------------------------
//------------------------- public setFootprintSize() ------------------------
//----------------------------------------------------------------------------

void vu1112115::setFootprintSize(dword size)
{
    m_FPSize = size;
}

//----------------------------------------------------------------------------
//------------------------- public getFootprintSize() ------------------------
//----------------------------------------------------------------------------

dword vu1112115::getFootprintSize() const
{
    return m_FPSize;
}

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu1112115::read()
{
    bool success = vu111211::read();
    if (!success) return false;

    //Allocate memory for the normals.
    if (m_Normals != 0) delete [] m_Normals;
#if defined(QUANTIZE_NORMALS)

    m_Normals = new byte[m_DataSize];
#else
    m_Normals = new float[m_DataSize*3];
#endif
    preprocess();
    return true;
}

//----------------------------------------------------------------------------
//------------------------- public readRaw() ---------------------------------
//----------------------------------------------------------------------------

bool vu1112115::readRaw(void)
{
    dword len;
    ifstream in;

    in.open(m_FileName, ios::in|ios::binary);//|ios::nocreate);
    if (!in.is_open()) return false;

    in.seekg(0, ios::end);
    len = in.tellg();
    in.seekg(0, ios::beg);

    in >> m_Dim1Size >> m_Dim2Size >> m_Dim3Size;
    if (in.fail()) return false;
    m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;

    m_Data = new byte[m_DataSize];
    in.read((char*)m_Data, m_DataSize);
    if (in.fail()) return false;

    in.close();

    //Allocate memory for the normals.
    if (m_Normals != 0) delete [] m_Normals;
#if defined(QUANTIZE_NORMALS)
    m_Normals = new byte[m_DataSize];
#else
    m_Normals = new float[m_DataSize*3];
#endif
    preprocess();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- private preprocess() -----------------------------
//----------------------------------------------------------------------------

void vu1112115::preprocess(void)
{
    float norm[3];
    float len;
    dword w, wh;
    dword i, j, k, index;

    w = m_Dim1Size;
    wh = m_Dim1Size*m_Dim2Size;

    //
    // Compute all of the normals and create a quantization
    // table with 256 entries.
    //
    index = 0;
#if defined(QUANTIZE_NORMALS)
    m_NTable.initCollection(m_DataSize);
#endif
    for(k=0;k<m_Dim3Size;++k)
    {
        for(j=0;j<m_Dim2Size;++j)
        {
            for(i=0;i<m_Dim1Size;++i)
            {
                if (i == 0)
                    norm[0] = m_Data[index+1]-m_Data[index];
                else if (i == m_Dim1Size-1)
                    norm[0] = m_Data[index]-m_Data[index-1];
                else
                    norm[0] = (m_Data[index+1]-m_Data[index-1])*0.5;

                if (j == 0)
                    norm[1] = m_Data[index+w]-m_Data[index];
                else if (j == m_Dim2Size-1)
                    norm[1] = m_Data[index]-m_Data[index-w];
                else
                    norm[1] = (m_Data[index+w]-m_Data[index-w])*0.5;

                if (k == 0)
                    norm[2] = m_Data[index+wh]-m_Data[index];
                else if (k == m_Dim3Size-1)
                    norm[2] = m_Data[index]-m_Data[index-wh];
                else
                    norm[2] = (m_Data[index+wh]-m_Data[index-wh])*0.5;

                len = (float)sqrt((double)((norm[0]*norm[0])+
                                           (norm[1]*norm[1])+
                                           (norm[2]*norm[2])));
                if (len > 0.0f)
                {
                    norm[0] /= len;
                    norm[1] /= len;
                    norm[2] /= len;
                }
#if defined(QUANTIZE_NORMALS)
                m_NTable.addToCollection(norm);
#else
                m_Normals[index*3] = norm[0];
                m_Normals[index*3+1] = norm[1];
                m_Normals[index*3+2] = norm[2];
#endif
                ++index;
            }
        }
    }

#if defined(QUANTIZE_NORMALS)
    m_NTable.computeTable();

    //
    // Create a map from each voxel into the table
    // of quantized normals.
    //
    index = 0;
    for(k=0;k<m_Dim3Size;++k)
    {
        for(j=0;j<m_Dim2Size;++j)
        {
            for(i=0;i<m_Dim1Size;++i)
            {
                if (i == 0)
                    norm[0] = m_Data[index+1]-m_Data[index];
                else if (i == m_Dim1Size-1)
                    norm[0] = m_Data[index]-m_Data[index-1];
                else
                    norm[0] = (m_Data[index+1]-m_Data[index-1])*0.5;

                if (j == 0)
                    norm[1] = m_Data[index+w]-m_Data[index];
                else if (j == m_Dim2Size-1)
                    norm[1] = m_Data[index]-m_Data[index-w];
                else
                    norm[1] = (m_Data[index+w]-m_Data[index-w])*0.5;

                if (k == 0)
                    norm[2] = m_Data[index+wh]-m_Data[index];
                else if (k == m_Dim3Size-1)
                    norm[2] = m_Data[index]-m_Data[index-wh];
                else
                    norm[2] = (m_Data[index+wh]-m_Data[index-wh])*0.5;

                len = (float)sqrt((double)((norm[0]*norm[0])+
                                           (norm[1]*norm[1])+
                                           (norm[2]*norm[2])));
                if (len > 0.0f)
                {
                    norm[0] /= len;
                    norm[1] /= len;
                    norm[2] /= len;
                }
                m_Normals[index] = (byte)m_NTable.findNearest(norm);

                ++index;
            }
        }
    }
#endif
}

//----------------------------------------------------------------------------
//------------------------- public render() ----------------------------------
//----------------------------------------------------------------------------

void vu1112115::render(void)
{
    int S_index, S_step, S_size;
    int M_index, M_step, M_size;
    int F_index, F_step, F_size;
    float dp[3];
    float vals[3];
    float *F, *M, *S;
    float dF, dM, dS;
    float rF, rM;
    float *n;
    int   index;
    dword density;

    dp[0] = (m_View[0] > 0.0f)?m_View[0]:m_View[0]*-1.0f;
    dp[1] = (m_View[1] > 0.0f)?m_View[1]:m_View[1]*-1.0f;
    dp[2] = (m_View[2] > 0.0f)?m_View[2]:m_View[2]*-1.0f;

    //
    // Compute indices, ranges, and values so that the rendering
    // loop can be as efficient as possible.
    //
    if (dp[0] > dp[1])
    {
        if (dp[0] > dp[2])
        {
            if (dp[1] > dp[2])
            {
                // 2, 1, 0  (i.e. z=fast, y=medium, x=slow)
                S = &vals[0];
                M = &vals[1];
                F = &vals[2];

                S_size = m_Dim1Size;
                if (m_View[0] >= 0.0f){
                    S_step  = 1;
                    *S = 0.0f;
                    dS = 1.0f;
                    index = 0;
                }else{
                    S_step  = -1;
                    *S = (float)m_Dim1Size-1.0f;
                    dS = -1.0f;
                    index = m_Dim1Size-1;
                }

                M_size = m_Dim2Size;
                if (m_View[1] >= 0.0f){
                    M_step  = m_Dim1Size;
                    *M = 0.0f;
                    dM = 1.0f;
                    rM = -1.0f * (float)m_Dim2Size;
                }else{
                    M_step  = -1*m_Dim1Size;
                    *M = (float)m_Dim2Size-1.0f;
                    dM = -1.0f;
                    rM = (float)m_Dim2Size;
                    index += (1-m_Dim2Size)*M_step;
                }

                F_size = m_Dim3Size;
                if (m_View[2] >= 0.0f){
                    F_step  = m_Dim1Size*m_Dim2Size;
                    *F = 0.0f;
                    dF = 1.0f;
                    rF = -1.0f * (float)m_Dim3Size;
                }else{
                    F_step  = -1*m_Dim1Size*m_Dim2Size;
                    *F = (float)m_Dim3Size-1.0f;
                    dF = -1.0f;
                    rF = (float)m_Dim3Size;
                    index += (1-m_Dim3Size)*F_step;
                }
            }
            else
            {
                // 1, 2, 0  (i.e. y=fast, z=medium, x=slow)
                S = &vals[0];
                F = &vals[1];
                M = &vals[2];

                S_size = m_Dim1Size;
                if (m_View[0] >= 0.0f){
                    S_step  = 1;
                    *S = 0.0f;
                    dS = 1.0f;
                    index = 0;
                }else{
                    S_step  = -1;
                    *S = (float)m_Dim1Size-1.0f;
                    dS = -1.0f;
                    index = m_Dim1Size-1;
                }

                F_size = m_Dim2Size;
                if (m_View[1] >= 0.0f){
                    F_step  = m_Dim1Size;
                    *F = 0.0f;
                    dF = 1.0f;
                    rF = -1.0f * (float)m_Dim2Size;
                }else{
                    F_step  = -1*m_Dim1Size;
                    *F = (float)m_Dim2Size-1.0f;
                    dF = -1.0f;
                    rF = (float)m_Dim2Size;
                    index += (1-m_Dim2Size)*F_step;
                }

                M_size = m_Dim3Size;
                if (m_View[2] >= 0.0f){
                    M_step  = m_Dim1Size*m_Dim2Size;
                    *M = 0.0f;
                    dM = 1.0f;
                    rM = -1.0f * (float)m_Dim3Size;
                }else{
                    M_step  = -1*m_Dim1Size*m_Dim2Size;
                    *M = (float)m_Dim3Size-1.0f;
                    dM = -1.0f;
                    rM = (float)m_Dim3Size;
                    index += (1-m_Dim3Size)*M_step;
                }
            }
        }
        else
        {
            // 1, 0, 2  (i.e. y=fast, x=medium, z=slow)
            M = &vals[0];
            F = &vals[1];
            S = &vals[2];

            M_size = m_Dim1Size;
            if (m_View[0] >= 0.0f){
                M_step  = 1;
                *M = 0.0f;
                dM = 1.0f;
                rM = -1.0f* (float)m_Dim1Size;
                index = 0;
            }else{
                M_step  = -1;
                *M = (float)m_Dim1Size-1.0f;
                dM = -1.0f;
                rM = (float)m_Dim1Size;
                index = m_Dim1Size-1;
            }

            F_size = m_Dim2Size;
            if (m_View[1] >= 0.0f){
                F_step  = m_Dim1Size;
                *F = 0.0f;
                dF = 1.0f;
                rF = -1.0f * (float)m_Dim2Size;
            }else{
                F_step  = -1*m_Dim1Size;
                *F = (float)m_Dim2Size-1.0f;
                dF = -1.0f;
                rF = (float)m_Dim2Size;
                index += (1-m_Dim2Size)*F_step;
            }

            S_size = m_Dim3Size;
            if (m_View[2] >= 0.0f){
                S_step  = m_Dim1Size*m_Dim2Size;
                *S = 0.0f;
                dS = 1.0f;
            }else{
                S_step  = -1*m_Dim1Size*m_Dim2Size;
                *S = (float)m_Dim3Size-1.0f;
                dS = -1.0f;
                index += (1-m_Dim3Size)*S_step;
            }
        }
    }
    else
    {
        if (dp[1] > dp[2])
        {
            if (dp[0] > dp[2])
            {
                // 2, 0, 1  (i.e. z=fast, x=medium, y=slow)
                M = &vals[0];
                S = &vals[1];
                F = &vals[2];

                M_size = m_Dim1Size;
                if (m_View[0] >= 0.0f){
                    M_step  = 1;
                    *M = 0.0f;
                    dM = 1.0f;
                    rM = -1.0f* (float)m_Dim1Size;
                    index = 0;
                }else{
                    M_step  = -1;
                    *M = (float)m_Dim1Size-1.0f;
                    dM = -1.0f;
                    rM = (float)m_Dim1Size;
                    index = m_Dim1Size-1;
                }

                S_size = m_Dim2Size;
                if (m_View[1] >= 0.0f){
                    S_step  = m_Dim1Size;
                    *S = 0.0f;
                    dS = 1.0f;
                }else{
                    S_step  = -1*m_Dim1Size;
                    *S = (float)m_Dim2Size-1.0f;
                    dS = -1.0f;
                    index += (1-m_Dim2Size)*S_step;
                }

                F_size = m_Dim3Size;
                if (m_View[2] >= 0.0f){
                    F_step  = m_Dim1Size*m_Dim2Size;
                    *F = 0.0f;
                    dF = 1.0f;
                    rF = -1.0f * (float)m_Dim3Size;
                }else{
                    F_step  = -1*m_Dim1Size*m_Dim2Size;
                    *F = (float)m_Dim3Size-1.0f;
                    dF = -1.0f;
                    rF = (float)m_Dim3Size;
                    index += (1-m_Dim3Size)*F_step;
                }
            }
            else
            {
                // 0, 2, 1  (i.e. x=fast, z=medium, y=slow)
                F = &vals[0];
                S = &vals[1];
                M = &vals[2];

                F_size = m_Dim1Size;
                if (m_View[0] >= 0.0f){
                    F_step  = 1;
                    *F = 0.0f;
                    dF = 1.0f;
                    rF = -1.0f* (float)m_Dim1Size;
                    index = 0;
                }else{
                    F_step  = -1;
                    *F = (float)m_Dim1Size-1.0f;
                    dF = -1.0f;
                    rF = (float)m_Dim1Size;
                    index = m_Dim1Size-1;
                }

                S_size = m_Dim2Size;
                if (m_View[1] >= 0.0f){
                    S_step  = m_Dim1Size;
                    *S = 0.0f;
                    dS = 1.0f;
                }else{
                    S_step  = -1*m_Dim1Size;
                    *S = (float)m_Dim2Size-1.0f;
                    dS = -1.0f;
                    index += (1-m_Dim2Size)*S_step;
                }

                M_size = m_Dim3Size;
                if (m_View[2] >= 0.0f){
                    M_step  = m_Dim1Size*m_Dim2Size;
                    *M = 0.0f;
                    dM = 1.0f;
                    rM = -1.0f * (float)m_Dim3Size;
                }else{
                    M_step  = -1*m_Dim1Size*m_Dim2Size;
                    *M = (float)m_Dim3Size-1.0f;
                    dM = -1.0f;
                    rM = (float)m_Dim3Size;
                    index += (1-m_Dim3Size)*M_step;
                }
            }
        }
        else
        {
            // 0, 1, 2  (i.e. x=fast, y=medium, z=slow)
            F = &vals[0];
            M = &vals[1];
            S = &vals[2];

            F_size = m_Dim1Size;
            if (m_View[0] >= 0.0f){
                F_step  = 1;
                *F = 0.0f;
                dF = 1.0f;
                rF = -1.0f* (float)m_Dim1Size;
                index = 0;
            }else{
                F_step  = -1;
                *F = (float)m_Dim1Size-1.0f;
                dF = -1.0f;
                rF = (float)m_Dim1Size;
                index = m_Dim1Size-1;
            }

            M_size = m_Dim2Size;
            if (m_View[1] >= 0.0f){
                M_step  = m_Dim1Size;
                *M = 0.0f;
                dM = 1.0f;
                rM = -1.0f * (float)m_Dim2Size;
            }else{
                M_step  = -1*m_Dim1Size;
                *M = (float)m_Dim2Size-1.0f;
                dM = -1.0f;
                rM = (float)m_Dim2Size;
                index += (1-m_Dim2Size)*M_step;;
            }

            S_size = m_Dim3Size;
            if (m_View[2] >= 0.0f){
                S_step  = m_Dim1Size*m_Dim2Size;
                *S = 0.0f;
                dS = 1.0f;
            }else{
                S_step  = -1*m_Dim1Size*m_Dim2Size;
                *S = (float)m_Dim3Size-1.0f;
                dS = -1.0f;
                index += (1-m_Dim3Size)*S_step;
            }
        }
    }

    S_step -= M_step*M_size;
    M_step -= F_step*F_size;

    vuColour7a col(m_TFunc.getLight());
    setLightColour(col);

    vuVector lpos = m_View;
	lpos *= -100;
    setLightPosition(lpos);
    
    //
    // The following loop is highly optimized for speed, given
    // the values and indices computed in the above conditionals.
    //
//NVCOMMENT    glBegin(GL_QUADS);
    for(S_index=0; S_index<S_size; ++S_index)
    {
        for(M_index=0; M_index<M_size; ++M_index)
        {
            for(F_index=0; F_index<F_size; ++F_index)
            {
                density = m_Data[index];
                if (m_TFunc[density][7] > 0.0f)
                {
//		    vuColourRGBa(col);
//		    m_TFunc.getRGBa(density,col);
//                    glColor4fv(col.getData()); //m_TFunc[density]);
                    setColour7a(m_TFunc[density]);
#if defined(QUANTIZE_NORMALS)
                    n = m_NTable[m_Normals[index]];
#else
                    n = &m_Normals[index*3];
#endif

#if defined(ONE_SIDED_LIGHTING)
                    if (n[0]*m_View[0] + n[1]*m_View[1] + n[2]*m_View[2] > 0.0f)
                    {
                        n[0] *= -1.0f;
                        n[1] *= -1.0f;
                        n[2] *= -1.0f;
                    }
#endif
//NVCOMMENT                    glNormal3fv(n);

                    drawSplatOrtho(vals);
                }

                index += F_step;
                *F += dF;
            }
            *F += rF;
            *M += dM;
            index += M_step;
        }
        *M += rM;
        *S += dS;
        index += S_step;
    }
    
    int retval [4];

    glGetIntegerv (GL_VIEWPORT, retval);

    m_ImgBuffer.init (retval [2] + 1, retval [3] + 1);

    glReadBuffer (GL_FRONT);

    glReadPixels (0, 0, m_ImgBuffer.getWidth () - 1, m_ImgBuffer.getHeight () - 1, GL_RGB, GL_UNSIGNED_BYTE, (unsigned char *) (m_ImgBuffer.get_rgb ()));



//NVCOMMENT    glEnd();
}

//----------------------------------------------------------------------------
//------------------------- private computeSplat() ---------------------------
//----------------------------------------------------------------------------

void vu1112115::computeSplat(void)
{
    dword index;
    dword i;
    dword j;
    double x;
    double y;
    double d;

    if (m_Footprint)
    {
        delete [] m_Footprint;
//NVCOMMENT        glDeleteTextures(1, &m_GLSplat);
    }
#if defined(COMBINERS)
    m_Footprint = new GLubyte[m_FPSize*m_FPSize];
#else
    m_Footprint = new GLubyte[m_FPSize*m_FPSize*2];
#endif

    index = 0;
    for(j=0;j<m_FPSize;++j)
    {
        for(i=0;i<m_FPSize;++i)
        {
            x = 0.5 - (double)i/(double)(m_FPSize-1);
            y = 0.5 - (double)j/(double)(m_FPSize-1);
            d = sqrt(x*x+y*y);
#if !defined(COMBINERS)
            m_Footprint[index++] = 255;
#endif
            m_Footprint[index++] = (GLubyte)(255.0*nelsonSplat(1.6*d));
        }
    }
}

//----------------------------------------------------------------------------
//------------------------- private nelsonSplat() ----------------------------
//----------------------------------------------------------------------------

double vu1112115::nelsonSplat(double r)
{
    double s = 0.8893919243498159;
    double t = 1.556227804798694;
    double a = 0.5575267703530060;
    double b = -1.157744128784905;
    double c = 0.6710333014812285;
    double d = 0.067598983313541278;
    double e = 0.2824741750452964;
    double f = t*t*(d+e*t);
    double g = -t*(2*d+3*e*t);
    double h = d+3*e*t;
    double v, u, rs, y, z, p, q;

    if(r == 0)
    {
        v = s*((a-f) + s*((-g)/2.0 + s*((b-h)/3.0 + s*(c+e)/4.0)))
          + t*(f + t*(g/2.0 + t*(h/3.0 + t*(-e)/4.0)));
    }
    else if(r < s)
    {
        rs = r*r;
        y = sqrt(s*s-rs);
        z = sqrt(t*t-rs);
        p = log(y+s);
        q = log(z+t);
        u = log(r);
        v = a*y + b*y*y*y/3.0 + b*y*rs + 0.5*c*rs*(y*s+rs*(p-u))
          + c*(y*s*s*s/4.0 - rs*0.125*(y*s+rs*(p-u)))
          + f*(z-y) + 0.5*(g-e*rs)*(z*t-y*s+rs*(q-p))
          + h*rs*(z-y) + (h/3.0)*(z*z*z-y*y*y)
          - e*(0.25*(z*t*t*t-y*s*s*s) - rs*0.125*(z*t-y*s+rs*(q-p)));
    }
    else if(r < t)
    {
        rs = r*r;
        z = sqrt(t*t-rs);
        q = log(z+t);
        u = log(r);
        v = f*z + 0.5*(g-e*rs)*(z*t+rs*(q-u)) + h*rs*z + (h/3.0)*z*z*z
          - e*(0.25*z*t*t*t-rs*0.125*(z*t+rs*(q-u)));
    }
    else
    {
        v = 0.0;
    }

    return 2.0*v;
}

//----------------------------------------------------------------------------
//------------------------- public initOpenGL() ------------------------------
//----------------------------------------------------------------------------
//#define ONE_SIDED_LIGHTING
    
void vu1112115::initOpenGL(void)
{
//    GLfloat shininess = 50.0f;
//    GLfloat specular[4] = {1.0f, 1.0f, 1.0f, 1.0f};
/*
#if defined(ONE_SIDED_LIGHTING)
    glMaterialf(GL_FRONT, GL_SHININESS, shininess);
    glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

    glPolygonMode(GL_FRONT, GL_FILL);
#else
**
    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specular);
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
**
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
#endif


    glShadeModel(GL_SMOOTH);
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_ALPHA_TEST);
    glDisable(GL_CULL_FACE);
    
    glGenTextures(1, &m_GLSplat);
    glBindTexture(GL_TEXTURE_2D, m_GLSplat);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);


    gluBuild2DMipmaps(GL_TEXTURE_2D, 2, m_FPSize, m_FPSize,
                      GL_LUMINANCE_ALPHA, GL_UNSIGNED_BYTE,
                      (void*)m_Footprint);
    glEnable(GL_TEXTURE_2D);

    glEnable(GL_BLEND);
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    
    initVertexProgram();
*/
}



//----------------------------------------------------------------------------
//------------------------- private drawSplatOrtho() -------------------------
//----------------------------------------------------------------------------

void vu1112115::drawSplatOrtho(float* v)
{
/*
    vuVector pos(v[0], v[1], v[2]);

    pos += m_Shift0;
    glTexCoord2fv(texcoord0);
    glVertex3fv(pos.getData());

    pos += m_Shift1;
    glTexCoord2fv(texcoord1);
    glVertex3fv(pos.getData());

    pos += m_Shift2;
    glTexCoord2fv(texcoord2);
    glVertex3fv(pos.getData());

    pos -= m_Shift1;
    glTexCoord2fv(texcoord3);
    glVertex3fv(pos.getData());
*/
}

//----------------------------------------------------------------------------
//------------------------- private drawSplatPerspective() -------------------
//----------------------------------------------------------------------------

void vu1112115::drawSplatPerspective(float* v)
{

}

void vu1112115::initVertexProgram(void)
{
/*NVCOMMENT
    glEnable(GL_VERTEX_PROGRAM_NV);

    GLuint m_ProgramIDs[4];

    // Load the programs and bind to g_OneLight
    glGenProgramsNV(4, (GLuint*)&m_ProgramIDs);
    glLoadProgramNV(GL_VERTEX_PROGRAM_NV, m_ProgramIDs[0], strlen((char*)g_OneLight), g_OneLight);
//    glLoadProgramNV(GL_VERTEX_PROGRAM_NV, m_ProgramIDs[1], strlen((char*)g_OneLight), g_TwoLights);
//    glLoadProgramNV(GL_VERTEX_PROGRAM_NV, m_ProgramIDs[2], strlen((char*)g_OneLight), g_ThreeLights);
//    glLoadProgramNV(GL_VERTEX_PROGRAM_NV, m_ProgramIDs[3], strlen((char*)g_OneLight), g_FourLights);
    glBindProgramNV(GL_VERTEX_PROGRAM_NV, m_ProgramIDs[0]);

    // Track the projection and modelview matrices
    // (so we know their memory locations)
    glTrackMatrixNV(GL_VERTEX_PROGRAM_NV, 0, GL_MODELVIEW, GL_IDENTITY_NV);
    glTrackMatrixNV(GL_VERTEX_PROGRAM_NV, 4, GL_PROJECTION, GL_IDENTITY_NV);
    glTrackMatrixNV(GL_VERTEX_PROGRAM_NV, 8, GL_MODELVIEW, GL_INVERSE_TRANSPOSE_NV);

    float m[3*8];
    for(int i=0; i<3*7; i++)
	m[(i/7)*8 + (i%7)] = CXF7toRGB[i/7][i%7];
    m[7] = m[15] = m[23] = 0;
    setCXFMatrix(m);
*/
}

void vu1112115::setCXFMatrix(float* m)
{
//NVCOMMENT    for(int i=0;i<6;i++)
//NVCOMMENT	glProgramParameter4fvNV(GL_VERTEX_PROGRAM_NV, 15+i, &m[i*4]);
}

void vu1112115::setColour7a(const float* col)
{
//NVCOMMENT    glVertexAttrib4fvNV(3, col);
//NVCOMMENT    glVertexAttrib4fvNV(4, col+4);
}

void vu1112115::setLightColour(vuColour7a& c)
{
    float* f;
    f = c.getData();
//NVCOMMENT    glProgramParameter4fvNV(GL_VERTEX_PROGRAM_NV, 13, f);
//NVCOMMENT    glProgramParameter4fvNV(GL_VERTEX_PROGRAM_NV, 14, f+4);
}

void vu1112115::setLightPosition(vuVector & p)
{
//NVCOMMENT    glProgramParameter4fvNV(GL_VERTEX_PROGRAM_NV, 12, p.getData());
}

void vu1112115::drawPic ()

{
//	glBegin (GL_QUADS);
	glDrawBuffer (GL_FRONT);
//	glDrawBuffer (GL_BACK);

//	cout << "drawPic ()" << endl;

	glFinish ();

//	glColor4f (0, 0, 0, 1.0);

	glDisable (GL_BLEND);

	glDrawPixels (m_ImgBuffer.getWidth () - 1, m_ImgBuffer.getHeight () - 1, GL_RGB, GL_UNSIGNED_BYTE, (unsigned char *) (m_ImgBuffer.get_rgb ()));
	glDrawBuffer (GL_BACK);
	glDrawPixels (m_ImgBuffer.getWidth () - 1, m_ImgBuffer.getHeight () - 1, GL_RGB, GL_UNSIGNED_BYTE, (unsigned char *) (m_ImgBuffer.get_rgb ()));

	glFinish ();
//	glDrawBuffer (GL_FRONT);
	glDrawBuffer (GL_BACK);

	glEnable (GL_BLEND);
//	glXSwapBuffers (

//	glFlush ();
//	glEnd ();
}

vuImage* vu1112115::getBuffer ()

{
	return &m_ImgBuffer;
}


