#ifndef _vu1112118_H_
#define _vu1112118_H_

#include <string>
#include <fstream.h>

#include "vuSimpleTypes.h"
#include "vuVector.h"
#include "vuColour31a.h"
#include "vuImage.h"
#include "vuSpectralImage.h"

#include "SimpleDefs.h"
#include "Filter.h"
#include "VolSet.h"

#include "../intensity.h"

class vu1112118;
typedef vu1112118 vuVolumeRegularUnimodal3d1B1ValSpecFVR;

class vu1112118 : public vu111211
{
public:
    vu1112118();
    ~vu1112118();

    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();

    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    //!Perform re-illumination of the spectral image with new light source.
    void setLight(const vuColour31a& light);
    
    //!Sets the camera viewing position for the render method.
    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

    friend void exit_fun();
    
    // Assignment operator for the volume class.
    vu1112118& operator=(const vu1112118& rhs);

    /** Perform complete preprocessing.
	This includes remapping the vud byte-volume to different
	spectral bands using the transfer function, zero-padding the
	volumes, transforming them to frequ. domain. */
    void preprocess(void);

    /** Update spectral image from extracted transformed slices. */
    void updateSImage();

    void write_fvr(char* out);// const;
    bool read_fvr(ifstream& fin, dword XSize, dword YSize, dword ZSize, dword d_size);

    bool doTempFilesExist(string fileName);
    void ensureTempDirectory();

 public:
    // Scale and bias the frequency slice into the rgb
    // slice.
    void scaleAndBias(void);
    
    void setDepthCueing(bool flag);
    
    void setIsDiffuseShading(bool flag);
    bool isDiffuseShading();

    void reset_refine();

    void doRefresh() {
	m_Volumes.m_Recomp = true;
    }
    
    void setLightDir(const vuVector &lightdir) {
	m_LightDir = lightdir;
    }

    /** Toggle spectral or conventional FVR.  If true a one
     dimensional ramp transfer function will be generated.  Call the
     function with 'false' before you pass a spectral transfer
     function. */
    void doSpectral(bool doit=true);
    
//window management
    //!Adjust to the new size of the render window
    void resize(int w, int h);
    
    //!handle a keyboard event (this belongs into the GUI!)
    bool keyboard(unsigned char key, int x, int y);

    float getZeroPas() {
	return m_ZeroPad;
    }

    void setOversample(float oversample) {
	m_Oversample = oversample;
    }
    void setZeroPad(float zeropad) {
	m_ZeroPad = zeropad;
    }

    float getOversample() {
	return m_Oversample;
    }

    vuImage* getImage() {
	return &m_Image;
    }
    	    
 private:
    VolumeSet	m_Volumes;
    float	m_ZeroPad;
    float	m_Oversample;
        
    SpecFVRNS::Filter *m_Filter;

    int     m_ScreenWidth;
    int     m_ScreenHeight;
    float   m_SliceXScale;
    float   m_SliceYScale;
    float   m_Scale;

    int m_currFilter;

    vuSpectralImage m_SImage;
    vuImage	    m_Image;
        
////////////////// PR
    dword num_div;
    dword x_pass_add;
    dword y_pass_add;

    dword x_stop;
    dword y_stop;
    dword x_pass;
    dword y_pass;
    
    dword refined;

    float m_LightIntensity;
    bool m_Relight;		//!< perform re-lighting
    bool m_DoSpectral;		//!< false=just to conventional FVR
    
    vuVector m_LightDir;
    
};

#endif
