#include <stdlib.h>
#include "glos.h"
#include <GL/gl.h>
#include <GL/glu.h>

#include <string.h>
#include <dirent.h>
#include <sys/stat.h>

#include "Volume.h"
#include "VolSet.h"
#include "TorstensFilters.h"
#include "SimpleDefs.h"

#include "specfvr.h"

#define TEMP_PATH		"./"
#define SFVR_NCOMPONENTS	7

using namespace SpecFVRNS;

// a friend who does nothing
void exit_fun() 
{
    cout <<"exit fun!"<<endl;
}

vu1112118::vu1112118() 
{

    m_Oversample = 1.0;
    m_ZeroPad = 1.0;

    //atexit(exit_fun);

    //m_Volumes.reset(NCOMP);
    m_Filter = new TorstensFilters(d0_c3_4ef);
    m_Volumes.setFilter(m_Filter);

    m_TFunc.resize(SFVR_NCOMPONENTS+1,256);
    m_Relight = true;
    m_Camera  = new vuCamera;
    //by default just do conventional FVR
    //that means, unmapped intensities are transformed, single channel
    m_DoSpectral = true;
    doSpectral(false);
}

vu1112118::~vu1112118() 
{
  if (m_Camera != NULL) {
    delete m_Camera;
    m_Camera = NULL;
  }
}

void vu1112118::reset_refine(void)
{
    x_pass = x_pass_add;
    y_pass = y_pass_add;
    x_stop = 0;
    y_stop = 0;

    refined = 0;
    m_Volumes.clearSlice();
}
///////

void vu1112118::setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right)
{
#if 0
  m_XAxis  = right;
  m_YAxis  = up;
  m_ZAxis  = view;

  m_XStep  = right;
  m_YStep  = up;
  
  m_XStep.makeUnit();
  m_YStep.makeUnit();

  m_XStep *= (float)(m_ImageXSize / m_SliceXSize);
  m_YStep *= (float)(m_ImageYSize / m_SliceYSize);

  updateShLight();
  m_Origin = m_Origin[0] * m_XAxis + m_Origin[1] * m_YAxis + m_Origin[2] * m_ZAxis;
#else
/*
  m_XAxis  = right;
  m_YAxis  = up;
  m_ZAxis  = view;

  m_XAxis.makeUnit();
  m_YAxis.makeUnit();
  m_ZAxis.makeUnit();

  m_XStep  = m_XAxis;
  m_YStep  = m_YAxis;
  
  m_XStep *= (float)(m_ImageXSize / m_SliceXSize);
  m_YStep *= (float)(m_ImageYSize / m_SliceYSize);

  updateShLight();
  m_Origin = -1 * (0.5*m_XAxis*m_SliceXSize+0.5*m_YAxis*m_SliceYSize+0.5*m_ZAxis*m_SliceYSize);

  //m_Origin = m_Origin[0] * m_XAxis + m_Origin[1] * m_YAxis + m_Origin[2] * m_ZAxis;
  */
#endif
}

void vu1112118::render(void)
{
    if (m_Volumes.m_Recomp) {
	if (refined) reset_refine();
	m_Volumes.setCamera(*m_Camera);
	m_Volumes.computeSlice(x_stop, y_stop, x_pass, y_pass);
	m_Volumes.m_Recomp = false;
	if(m_DoSpectral) updateSImage();
    }
    if(m_DoSpectral && m_Relight) {
	m_SImage.getRGBImage(m_Image);
	m_Relight = false;
    }
    glClear(GL_COLOR_BUFFER_BIT);
    glPixelZoom(m_SliceXScale, m_SliceYScale);
    if(m_DoSpectral)
	m_Image.blit();
    else {
	glRasterPos2i(0,0);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	glColor3f(1.0f,1.0f,1.0f);
	glDrawPixels(m_Volumes[0]->getSliceWidth(),
		     m_Volumes[0]->getSliceHeight(),
		     GL_LUMINANCE,
		     GL_FLOAT,
		     m_Volumes[0]->getSliceData());
    }
}

void vu1112118::updateSImage() {
    int c;
    for(c=0;c<m_Volumes.m_NVolumes;c++) {
	float *slice = m_Volumes[c]->getSliceData();
	int w=m_Volumes[c]->getSliceWidth();
	int h=m_Volumes[c]->getSliceHeight();
	int px,py;
	for(py=0;py<h;py++) {
	    for(px=0;px<w;px++,slice++) {
		m_SImage.get_xy_data(px,py)[c] = *slice;
	    }
	}
    }
    m_SImage.create_black_mask();
    m_Relight = true;
}

void vu1112118::resize(int w, int h)
{
    glViewport(0, 0, (GLsizei)w, (GLsizei)h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0, (GLsizei)w, 0, (GLsizei)h);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    m_SliceXScale = (float)w/(float)m_Volumes[0]->getSliceWidth();
    m_SliceYScale = (float)h/(float)m_Volumes[0]->getSliceWidth();

    m_ScreenWidth = w;
    m_ScreenHeight = h;
    
    m_Image.init(w,h);
    m_SImage.init(w,h);
}

bool vu1112118::keyboard(unsigned char key, int x, int y)
{
    bool recam = false;
    switch(key)
    {
	case 27: 	
	    cout <<"Hit ESC."<<endl;
	    exit(0); 
	    break;
	case '4': 	m_Volumes.rotateSliceY(-3.0f);
	    m_Volumes.m_Recomp = true; recam = true;
	    break;
	case '6': 	m_Volumes.rotateSliceY(3.0f);
	    m_Volumes.m_Recomp = true; recam = true;
	    break;
	case '8': 	m_Volumes.rotateSliceX(3.0f);
	    m_Volumes.m_Recomp = true; recam = true;
	    break;
	case '2': 	m_Volumes.rotateSliceX(-3.0f);
	    m_Volumes.m_Recomp = true; recam = true;
	    break;
	case '7': 	m_Volumes.rotateSliceZ(-3.0f);
	    m_Volumes.m_Recomp = true; recam = true;
	    break;
	case '9': 	m_Volumes.rotateSliceZ(3.0f);
	    m_Volumes.m_Recomp = true; recam = true;
	    break;
	case 's': 	
	    m_Scale *= 1.0f/0.95f;  
	    m_Volumes.setSliceScale(m_Scale); 
	    m_Volumes.m_Recomp = true; break;
	case 'x': 	
	    m_Scale *= 0.95f;  
	    m_Volumes.setSliceScale(m_Scale); 
	    m_Volumes.m_Recomp = true; break;
	case 'a': 	m_Volumes[0]->writeImage(); break;
	case 'd':	
	    if (!m_Volumes.setFilter(++m_currFilter)) {
	    cout << "No more filters" << endl;
	    m_Volumes.setFilter(--m_currFilter);
	    }
	    m_Volumes.m_Recomp = true; break;
	case 'c':	
	    if (!m_Volumes.setFilter(--m_currFilter)) {
		cout << "No more filters" << endl;
		m_Volumes.setFilter(++m_currFilter);
	    }
	    m_Volumes.m_Recomp = true; break;
	case 'r': 	
	    if (refined < num_div) {
		x_stop += x_pass_add;
		y_stop += y_pass_add;
		
		if (refined == num_div - 1) {
		    x_pass = m_Volumes[0]->getInternalSliceWidth()  / 2 - x_stop;
		    y_pass = m_Volumes[0]->getInternalSliceHeight() / 2 - y_stop;
		}
		
		refined++;
		m_Volumes.computeSlice(x_stop, y_stop, x_pass, y_pass);
		updateSImage();
	    }
	    break;
	case '?':
	    cout <<"Help:"<<endl;
	    cout <<" r   - refine (can be done multiple times)"<<endl;
	    cout <<" c,d - toggle filter" << endl;
	    break;
	default: 
	    //cout<<"Press '?' for Help"<<endl;
	    return false;
	    break;
    }
    if(recam) {
	m_Volumes[0]->getCamera(*m_Camera);
    }
    return true;
}

bool vu1112118::doTempFilesExist(string fileName) {
  FILE *fileStream;

  fileStream = fopen(fileName.c_str(), "r");
  if (fileStream != NULL) {
    fclose(fileStream);
    return true;
  }
  else 
    return false;
}

void vu1112118::ensureTempDirectory() {
    DIR *tmpDir;
    
    tmpDir = opendir(TEMP_PATH);
    if (tmpDir == NULL) {
	cerr << "createDirectory +++++++++++++++++++++++++++++++++++++++" << endl;
#ifdef WIN32
	mkdir(TEMP_PATH);
#else
	mkdir(TEMP_PATH,
	      S_IRUSR | S_IWUSR | S_IXUSR |
	      S_IRGRP | S_IWGRP | S_IXGRP |
	      S_IROTH | S_IWOTH | S_IXOTH);
#endif
    }
  else
      closedir(tmpDir);
}

bool vu1112118::read()
{
    m_currFilter = 0;
  string myFile(this->getFileName());

  unsigned int len = myFile.length();
  unsigned int pos = myFile.rfind("/", len);

  if ((pos != string::npos) && (pos < len)) {
    myFile = myFile.substr(pos+1, len);
  }
  len = myFile.length();

  if (len >4) { // myFile must contain at least the file extension
    myFile.replace(len-4, len, "0.fvr");
    myFile = string(TEMP_PATH) + myFile;

    cerr << "myFile is " << myFile << endl;

    if (!this->doTempFilesExist(myFile)) {
      bool success = vu111211::read();
      if (!success) return false;

      cerr << "x=" << m_Dim1Size << "y=" << m_Dim2Size << "z=" << m_Dim3Size;
      cerr << endl;

      this->ensureTempDirectory();

      preprocess();

      //TODO: all should be written, not just one
      //write_fvr((char *)myFile.c_str());
    }

#if 0
    char *fname = (char *)myFile.c_str();
    
    cout << "PROCESSING " << fname << endl;
    
    bool ret = m_Volumes.read(fname, m_Oversample, m_ZeroPad);
    
    cout << "FINISHED PROCESSING" << endl;

    if (!ret) {
	cout << "bad file\n";
	return false;
    }
#endif    
  }
  
    cout << "slice width " << m_Volumes[0]->getSliceWidth()<< endl;
    return true;
}

bool vu1112118::readRaw(void)
{
#if 0
  dword len;
  ifstream in;

  cerr << "+++++++++++++ rawRead is called" << endl;

#ifdef IS_NOCREATE_NEEDED
  in.open(m_FileName, ios::in|ios::binary|ios::nocreate);
#else
  // The nocreate is not available on the IRIX boxes that we were compiling
  // this code on, so we had to remove this part from
  in.open(m_FileName, ios::in|ios::binary);
#endif
  if (!in.is_open()) return false;

  in.seekg(0, ios::end);
  len = in.tellg();
  in.seekg(0, ios::beg);

  in >> m_Dim1Size >> m_Dim2Size >> m_Dim3Size;
  if (in.fail()) return false;
  m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;

  m_Data = new byte[m_DataSize];
  in.read((char *) (m_Data), int (m_DataSize));
  if (in.fail()) return false;

  in.close();

  preprocess();
#endif

  return true;
}

void vu1112118::preprocess() 
{
    //convert the byte .vud volume to frequency volumes
    m_Volumes.setFilter(m_currFilter);
    m_TFunc.normalizeAlphaToOne();
    m_Volumes.buildColourVolumes(m_Data,
				 m_Dim1Size, m_Dim2Size, m_Dim3Size,
				 sizeof(byte), m_TFunc, 
				 m_Oversample, m_ZeroPad);
    m_Volumes.setFilter(m_currFilter);

    m_Scale = 8.0f/(float)m_Volumes[0]->getInternalSliceWidth();
    m_Volumes.setSliceScale(m_Scale);

    num_div = 4;
    x_pass_add = m_Volumes[0]->getInternalSliceWidth() / num_div / 2;
    y_pass_add = m_Volumes[0]->getInternalSliceHeight() / num_div / 2;
    reset_refine();
    refined = false;

    m_Volumes.m_Recomp = true;

    m_ScreenWidth = m_Volumes[0]->getSliceWidth()*2;
    m_ScreenHeight = m_Volumes[0]->getSliceHeight()*2;
}

void vu1112118::write_fvr(char* out) 
{
  cerr << "Writing transformed volume to files...\n";

  m_Volumes.write_fvr(out);
/*
  int len = strlen(out) + 1;
  char *out = new char[len];
  memset(out, 0, len);
  strcpy(out, fileName);

  for(int yl = 0; yl < VOLUME_MAX_NUM; yl++)
    {
      ofstream fout;
      out[len - 6] = char('0' + yl);
      cerr << out << endl;
      fout.open(out, ios::out|ios::binary);
      write_fvr_head(fout, m_Dim1Size, m_Dim2Size, m_Dim3Size, sizeof(t_data));
#ifdef SOLARIS
      fout.write((char*)&m_Yarray[yl][0], m_Dim1Size * m_Dim2Size * m_Dim3Size * 2 * sizeof(t_data));
#else
      fout.write((byte*)&m_Yarray[yl][0], m_Dim1Size * m_Dim2Size * m_Dim3Size * 2 * sizeof(t_data));
#endif
      
      fout.flush();
      fout.close();
    }
*/
  
  /*nasty bug, forgot to comment!
    ofstream fout;
    fout.open(out, ios::out|ios::binary);
    
    write_fvr_head(fout, m_Dim1Size, m_Dim2Size, m_Dim3Size, sizeof(t_data));
    fout.write((byte*)m_Volume, m_Dim1Size * m_Dim2Size * m_Dim3Size * 2 * sizeof(t_data));
    
    fout.close();
  */
  // delete out;
}

void vu1112118::setLight(const vuColour31a& light) 
{
    m_SImage.set_light(vuColour7a(light));
    m_Relight = true;
}

void vu1112118::doSpectral(bool doit) 
{
    if((m_DoSpectral && doit) || (!m_DoSpectral && !doit)) return;
    m_DoSpectral = doit;
    if(m_DoSpectral) {
	m_TFunc.resize(SFVR_NCOMPONENTS+1,256);
    } else {
	m_TFunc.resize(2,256);
	m_TFunc.fromMap(vuMap());	//is identity by default
    }
}
