#include <stdlib.h>
#include "glos.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <string.h>
#include "vuColour31a.h"
#include "vuSimpleTypes.h"
#include "vuTFunc/vuTFDesignSpec.h"

#include "Volume.h"
#include "VolSet.h"
#include "TorstensFilters.h"
#include "SimpleDefs.h"
#include "specfvr.h"

vu1112118	g_Renderer;
vuColour31a	g_Light;

void InitOpenGL(void)
{
    glClearColor(0.8,0.8,0.8,0);
    glShadeModel(GL_FLAT);
}

void Display(void)
{
    g_Renderer.render();
    glutSwapBuffers();
}

void Reshape(int w, int h)
{
    g_Renderer.resize(w,h);
}

void Keyboard(unsigned char key, int x, int y)
{
    if(!g_Renderer.keyboard(key, x, y)) {
	switch(key) 
	{
	    case 'b' : g_Light *= 0.5;
		g_Renderer.setLight(g_Light);
		break;
	    case 'g': g_Light *= 2;
		g_Renderer.setLight(g_Light);
		break;
	}
    }
    glutPostRedisplay();
}

int main(int argc, char** argv)
{
	if (argc < 2 || argc > 4) {
		cerr << "Usage : " << argv[0] << " <filename> <oversample> <zero pad>\n";
		return -1;
	}

	vuTFDesignSpec tf(32,256);
	if(!tf.loadTF("frog.spec.tf"))
	    cout << "Couldn't load frog" << endl;
	tf.generateFunction();
	g_Light = vuColour31a(tf.getLightNode(0).col);
	g_Renderer.setLight(g_Light);
	g_Renderer.setTransferFunc(tf);

	float oversample = 1.0;
	if (argc > 2) oversample = atof(argv[2]);
	if (oversample < 1.0) oversample = 1.0;
	g_Renderer.setOversample(oversample);
	
	float zeroPad = 1.0;
	if (argc > 3)
    	zeroPad= atof(argv[3]);
	if (zeroPad < 1.0) zeroPad = ROOT_TWO;
	g_Renderer.setZeroPad(zeroPad);

	cout << "Zero pad: " << zeroPad << endl;
	cout << "Oversample: " << oversample << endl;

	g_Renderer.setFileName(argv[1]);
	bool isread = g_Renderer.read();
	cout << "reading " << (isread?"successful":"failed")<<endl;
	if(!isread) return -1;

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowSize(500, 500);
	glutCreateWindow("SpectralFVR");

	InitOpenGL();

	glutDisplayFunc(Display);
	glutReshapeFunc(Reshape);
	glutKeyboardFunc(Keyboard);

	g_Renderer.resize(500,500);
	cout<<"resized!"<< endl;
	glutMainLoop();

	cout <<"after the looop";
	
	return 0;
}
