#ifndef _VOLUME_H_
#define _VOLUME_H_

#include <fstream.h>
#include "vuTFunc/vuTFIntensity.h"
#include "vuSimpleTypes.h"
#include "vuCamera.h"
#include "vuVector.h"
#include "Filter.h"

#define NCOMP	7

class VolumeSet;

//#define FVR_NO_SLICE_COPY

class Volume
{
    friend class VolumeSet;
public:
    // Default constructor, copy constructor,
    // and destructor.
    Volume();
    Volume(Volume& inst);
    ~Volume();

    // Assignment operator for the volume class.
    Volume& operator=(Volume& rhs);

   //! read file.
    bool convert(byte* data, dword XSize, dword YSize, dword ZSize, 
		 dword d_size, const vuTFIntensity &tfunc, dword component,
		 float osamp=1.0f, float m_pad=1.0f, dword a_pad=0);
    	
    // Write the current image to disk.
    void writeImage(void);

    // Set the interpolation filter.
    void setFilter(SpecFVRNS::Filter* filter);

    // Set the scale and bias for the slice extraction
    // stage of the algorithm.
    void setSliceScale(float scale);
    void setSliceBias(float bias);

    // Rotate the slice about its x, y, or z axis.
    // The rotations are local to the slice (it carries
    // its own coordinate axis system).
    void rotateSliceX(float alpha);
    void rotateSliceY(float alpha);
    void rotateSliceZ(float alpha);
    void setViewMatrix(const vuMatrix& mat);
    void setCamera(const vuCamera& cam);
    void getCamera(vuCamera& cam) const;

    // Compute the slice for the current angle and
    // return the rgb's in a byte*.
    // Stop is middle section, pass is bandwidth
    void clearSlice(void);
    void computeSlice(void);
    void computeSlice(dword x_stop, dword y_stop, dword x_pass, dword y_pass);
    float* getSliceData(void);

    // Get the dimensions of the current slice (for
    // the current version, the same values are returned
    // for all angles.)
    dword getSliceWidth(void) const;
    dword getSliceHeight(void) const;

    dword getInternalSliceWidth(void) const;
    dword getInternalSliceHeight(void) const;

    // set oversampling -- 2 uses twice the number of samples
    void setOversampling(float s);

protected:
    // Set the width of the wrap in the frequency
    // domain.  Should be half the filter size.
    void setWrap(dword wrap);

    // Fix the frequency volume so that it wraps its
    // values periodically to half of the filter width.
    void wrapVolume(void);

    // Interpolate the slice, using the currently
    // selected filter.
    void interpolateSlice(void);
    void interpolateSlice(dword x_stop, dword y_stop, dword x_pass, dword y_pass);

    // Scale and bias the frequency slice into the rgb
    // slice.
    void scaleAndBias(void);

	inline int Volume::vcoord(int x, int y, int z) const
	{
		return ((z * m_YSize + y) * m_XSize + x) * 2;
	}

	inline int Volume::scoord(int x, int y) const
	{
		return (y * m_SliceXSize + x) * 2;
	}

	void preprocess(void);
	void write_fvr(char* out) const;
	bool read_fvr(ifstream& fin, dword XSize, dword YSize, dword ZSize, dword d_size);
protected:
    // Variables for the volume.
    float* m_Volume;       // Volume frequency data
    dword  m_XSize;        // Width of volume (and slice)
    dword  m_YSize;        // Height of volume (and slice)
    dword  m_ZSize;        // Depth of volume
    dword  m_Wrap;         // Width of the wrap on the volume

    // Variables for the interpolation filter
    SpecFVRNS::Filter* m_Filter;

    // Variables for the slice
    float* m_Slice;		// Slice frequency data

    vuVector m_XStep;        // Xstep for sampling
    vuVector m_YStep;        // Ystep for sampling
    dword  m_SliceXSize;   // Slice x-size
    dword  m_SliceYSize;   // Slice y-size
    vuVector m_XAxis;        // Slice x-axis
    vuVector m_YAxis;        // Slice y-axis
    vuVector m_ZAxis;        // Slice z-axis
    vuVector m_Origin;       // Bottom left corner of slice

    // image vars
    float* m_Image;
    dword m_ImageXSize;
    dword m_ImageYSize;
    dword m_ImageStep;
    float* m_SlicePtr;
    float m_Scale;         // Slice scale factor
    float m_Bias;          // Slice bias factor

    int   m_CurImage;      // Counter for saved images.

    dword m_InnerXSize;
    dword m_InnerYSize;
    
#ifndef FVR_NO_SLICE_COPY
    float* m_SSlice;	// Slice spatial data
#endif
};

#endif


