#include "TorstensFilters.h"
#include "VolSet.h"

using namespace SpecFVRNS;

VolumeSet::VolumeSet(int nvolumes)
{
    m_Volumes = NULL;
    m_Filter = NULL;
    createVolumes(nvolumes,true);
}

VolumeSet::~VolumeSet() 
{
    destroyData(true);
}

void VolumeSet::createVolumes(int nvolumes, bool initFilter) 
{
    cout << "initializing " << nvolumes << " volumes" << endl;
    if(m_Volumes) destroyData(initFilter);
    m_NVolumes = nvolumes;
    if(initFilter) {
	cout << "reseting filter" << endl;
	m_Filter = new TorstensFilters(d0_c3_4ef);
    }
    
    if(nvolumes) {
	m_Volumes = new Volume*[m_NVolumes];
	int c;
	for(c=0; c<m_NVolumes; c++)
	    m_Volumes[c]= new Volume;
	if(!initFilter) setFilter(m_Filter);
    } else
	m_Volumes = NULL;
    m_Recomp=false;
}

void VolumeSet::destroyData(bool destroyFilter) 
{
    if(m_Volumes) {
	int c;
	for(c=0;c<m_NVolumes;c++) {
	    if(m_Volumes[c]) delete m_Volumes[c];
	}
	delete m_Volumes;
	m_Volumes = NULL;
	m_NVolumes = 0;
    }
    if(destroyFilter && m_Filter) {
	delete m_Filter;
	m_Filter=NULL;
    }
}

#define FILTER_SET_SUB(x)	\
	m_Filter = new TorstensFilters((x));	\
	ITERATE_VOLS(setFilter(m_Filter));	\
	//cout << #x << " : Filter width = " << m_Filter->getWidth() << endl;

bool VolumeSet::setFilter(int num)
{
	Filter* tmp = m_Filter;
	switch(num) {
	case 0:  FILTER_SET_SUB(d0_c0_1ef); break;
	case 1:  FILTER_SET_SUB(d0_c0_2ef); break;
	case 2:  FILTER_SET_SUB(d0_c0_3ef); break;
	case 3:  FILTER_SET_SUB(d0_c0_4ef); break;
	case 4:  FILTER_SET_SUB(d0_c1_1ef); break;
	case 5:  FILTER_SET_SUB(d0_c1_2ef); break;
	case 6:  FILTER_SET_SUB(d0_c1_3ef); break;
	case 7:  FILTER_SET_SUB(d0_c1_4ef); break;
	case 8:  FILTER_SET_SUB(d0_c2_1ef); break;
	case 9:  FILTER_SET_SUB(d0_c2_2ef); break;
	case 10: FILTER_SET_SUB(d0_c2_3ef); break;
	case 11: FILTER_SET_SUB(d0_c2_4ef); break;
	case 12: FILTER_SET_SUB(d0_c3_1ef); break;
	case 13: FILTER_SET_SUB(d0_c3_2ef); break;
	case 14: FILTER_SET_SUB(d0_c3_3ef); break;
	case 15: FILTER_SET_SUB(d0_c3_4ef); break;
	case 16: FILTER_SET_SUB(d0_cn_1ef); break;
	case 17: FILTER_SET_SUB(d0_cn_2ef); break;
	case 18: FILTER_SET_SUB(d0_cn_3ef); break;
	case 19: FILTER_SET_SUB(d0_cn_4ef); break;
	default: return false;
	}
	if (tmp) delete tmp;
	m_Recomp = true;
	return true;
}

bool VolumeSet::setFilter(Filter* filter)
{
    if(filter == m_Filter) return true;
    Filter* tmp = m_Filter;
    m_Filter = filter;
    int c;
    for( c=0; c<m_NVolumes; c++) {
	if(m_Volumes[c]) m_Volumes[c]->setFilter(m_Filter);
    }
    //ITERATE_VOLS(setFilter(m_Filter));
    //cout << "Filter width = " << m_Filter->getWidth() << endl;
    if (tmp) delete tmp;    
    m_Recomp = true;
    return true;
}

// Read the volume
bool VolumeSet::read(char* in, float s, float m_pad, dword a_pad ) 
{
    if (!in) return false;
    createVolumes(1);
    if(!m_Filter) {
 	cout << "No Filter set!" << endl;
 	return false;
    }
    
/* roadmap
   (in VolSet) load a transfer function
   (combine with vuVolume?)
   (in VolSet) load a vud, classify
   create different volumes
   transform to Freq
   
   rendering:
   slice 
   inverse transform
   create spectral image
   illuminate image -> create RGB
   draw pixels
   
   control:
   have (two/several) light sources
   set weights
*/
    
    //createVolumes(1);
    
    //m_Volumes[0]->setFilter(m_Filter);
    //m_Volumes[0]->read(in,s,m_pad,a_pad);
    cout <<"read not implemented anymore"<<endl;
    return false;
    
}

bool VolumeSet::write_fvr(char* fn) 
{
    if(!fn) return false;
    if(m_NVolumes == 0) return false;
    m_Volumes[0]->write_fvr(fn);
    return true;
}

void VolumeSet::buildColourVolumes(byte *data, 
				   dword xsize, dword ysize, dword zsize,
				   dword dsize, const vuTFIntensity &tfunc,
				   float osamp, float m_pad, dword a_pad)
{
    createVolumes(tfunc.getNComponents()-1); //no alpha volume
    if(!m_Filter) {
	cerr <<"No filter defined."<<endl;
	return;
    }
    int c;
    for(c=0;c<m_NVolumes;c++) {
	m_Volumes[c]->setFilter(m_Filter);
	m_Volumes[c]->convert(data, xsize, ysize, zsize, dsize,
			      tfunc, c, osamp, m_pad, a_pad);
    }    
}
