#ifndef _TRANSFORM_H_
#define _TRANSFORM_H_

// basic transform fns -- since we only need one type of transform at a time,
// it would be a waste to make this more general. The transforms directory
// should contain any number of source files which implement this header
// with a particular transform. This was only a relinking is necessary to
// change compatible transforms. As a result, there should be no data
// members declared here, but should instead be static members of a source
// file. All data members are therefore global, so this is not a class since
// instantiation does not create local vars If there are worries about scoping,
// just add in a namespace.

// The shift fns can be either in the current domain or using a shift theorem,
// whichever is faster

#include "vuSimpleTypes.h"

namespace SpecFVRNS 
{
    
// general init/destroy
void initTransforms(void);
void destroyTransforms(void);

// inverse 2D transform -- out of place!! Put answer in y!
void initTransform2D(dword XSize, dword YSize);
void transform2D(float* x);
void destroyTransform2D(void);

// 3D transform
void initTransform3D(dword XSize, dword YSize, dword ZSize);
void transform3D(float* x);
void destroyTransform3D(void);

void shift2D(float* x, dword XSize, dword YSize);
void shift_copy2D(float* dest, float* src, dword XSize, dword YSize);
void shift3D(float* x, dword XSize, dword YSize, dword ZSize);
 
} // of namespace

#endif
