#ifndef _TORSTENSFILTERS_H_
#define _TORSTENSFILTERS_H_

#include "Filter.h"
#include "tfilters.h"


namespace SpecFVRNS 
{
    

// max extent of a filter for things to work
#define MAX_TFILTER_EXTENT	10

class TorstensFilters : public Filter
{
public:
    TorstensFilters();
    TorstensFilters(TorstensFilters& l);
    TorstensFilters(int (*filter)(float a, float t, float *coeff), float a = 0.0f);
    virtual ~TorstensFilters();

    void SetFilter(int (*filter)(float a, float t, float *coeff), float a = 0.0f);

	virtual dword getWidth(void);

    TorstensFilters& operator=(TorstensFilters& rhs);

protected:
	virtual void MakeWeights(void);

private:
    void MakeWeightCube(float* w, float ti, float tj, float tk);

private:
    int (*m_Filter)(float a, float t, float *coeff);
    dword m_FilterWidth;
	float m_a;
};

} // endof namespace

#endif
