#include "TorstensFilters.h"

namespace SpecFVRNS 
{
    
TorstensFilters::TorstensFilters()
{
}

TorstensFilters::TorstensFilters(TorstensFilters& l)
{
}

TorstensFilters::TorstensFilters(int (*filter)(float a, float t, float *coeff), float a)
{
	SetFilter(filter, a);
}

TorstensFilters::~TorstensFilters()
{
}

TorstensFilters& TorstensFilters::operator=(TorstensFilters& rhs)
{
	return *this;
}

void TorstensFilters::SetFilter(int (*filter)(float a, float t, float *coeff), float a)
{
	float Coeff[MAX_TFILTER_EXTENT];
	m_Filter = filter;
	m_FilterWidth = (dword) m_Filter(a, 0, Coeff);
	m_FilterSize = m_FilterWidth * m_FilterWidth * m_FilterWidth;
	m_a = a;

	MakeWeights();
}

dword TorstensFilters::getWidth(void)
{
	return m_FilterWidth;
}

void TorstensFilters::MakeWeights(void)
{
	float ti, tj, tk;
	float tstep;
	dword pos;

	m_Weights = new float[FILTER_TABLE_SIZE *
						FILTER_TABLE_SIZE *
						FILTER_TABLE_SIZE * m_FilterSize];

	tstep = 1.0f / (float)FILTER_TABLE_SIZE;

	pos = 0;
	tk = 0;
	for(dword k = 0; k < FILTER_TABLE_SIZE; ++k) {
		tj = 0;
		for(dword j = 0; j < FILTER_TABLE_SIZE; ++j) {
			ti = 0;
			for(dword i = 0;i < FILTER_TABLE_SIZE; ++i) {
				MakeWeightCube(&m_Weights[pos], ti, tj, tk);

				pos += m_FilterSize;
				ti += tstep;
			}
			tj += tstep;
		}
		tk += tstep;
	}
}

void TorstensFilters::MakeWeightCube(float* w, float ti, float tj, float tk)
{
	float wi[MAX_TFILTER_EXTENT], wj[MAX_TFILTER_EXTENT], wk[MAX_TFILTER_EXTENT];

	m_Filter(m_a, ti, wi);
	m_Filter(m_a, tj, wj);
	m_Filter(m_a, tk, wk);

	dword pos = 0;
	for(dword k = 0; k < m_FilterWidth; ++k)
		for(dword j = 0; j < m_FilterWidth; ++j)
		    for(dword i = 0; i < m_FilterWidth; ++i)
			w[pos++] = wi[i] * wj[j] * wk[k];
}
 
} // end of namespace
