#include "Image_io.h"
#include <stdio.h>
#include <string.h>
#include <iostream.h>

namespace SpecFVRNS
{
    
// complex pad n spaces
static float* pad(float* v, dword n)
{
	for (dword i = 0; i < n; ++i) {
		*(v++) = 0.0f;
		*(v++) = 0.0f;
	}
	return v;
}

// pad n spaces
static byte* pad_r(byte* v, dword n)
{
	for (dword i = 0; i < n; ++i) {
		*(v++) = 0;
	}
	return v;
}

static dword readNumber(ifstream& fin)
{
	dword n = 0;
	int c;

	c = fin.get();
	while((c!=' ') && (c!=10) && (c!=13))
	{
		n = n*10 + ((dword)c-'0');
		c = fin.get();
	}
	return n;
}

static void writeNumber(ofstream& fout, dword n)
{
	char number[16];

	sprintf(number, "%ld", n);
	fout.write(number, strlen(number));
	fout.put(' ');
}

void read_raw(ifstream& fin, float* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size)
{
	if (!fin.is_open()) return;

	float* v_ptr = vol;

	dword lowX = (X - XSize) / 2;
	dword lowY = (Y - YSize) / 2;
	dword lowZ = (Z - ZSize) / 2;

	dword hiX = X - lowX - XSize;
	dword hiY = Y - lowY - YSize;
	dword hiZ = Z - lowZ - ZSize;

	v_ptr = pad(v_ptr, lowZ * X * Y);
	for (dword k = 0; k < ZSize; ++k) {

		v_ptr = pad(v_ptr, lowY * X);
		for (dword j = 0; j < YSize; ++j) {

			v_ptr = pad(v_ptr, lowX);
			for (dword i = 0; i < XSize; ++i) {

				// convert d_size bytes to floating point
				float tmp = 0.0f;
				for (dword d = 0; d < d_size; ++d) {
					tmp *= 256.0f;
					int c = fin.get();
					if (c < 0) cerr << "huh??\n";
					tmp += (float) c;
				}
				*(v_ptr++) = tmp;
				*(v_ptr++) = 0.0f;

			}
			v_ptr = pad(v_ptr, hiX);

		}
		v_ptr = pad(v_ptr, hiY * X);

	}
	v_ptr = pad(v_ptr, hiZ * X * Y);
}

void read_raw(byte *data, float* vol, dword X, dword Y, dword Z, 
	      dword XSize, dword YSize, dword ZSize, dword d_size)
{
	if (!data) return;

	float* v_ptr = vol;

	dword lowX = (X - XSize) / 2;
	dword lowY = (Y - YSize) / 2;
	dword lowZ = (Z - ZSize) / 2;

	dword hiX = X - lowX - XSize;
	dword hiY = Y - lowY - YSize;
	dword hiZ = Z - lowZ - ZSize;

	v_ptr = pad(v_ptr, lowZ * X * Y);
	for (dword k = 0; k < ZSize; ++k) {

		v_ptr = pad(v_ptr, lowY * X);
		for (dword j = 0; j < YSize; ++j) {

			v_ptr = pad(v_ptr, lowX);
			for (dword i = 0; i < XSize; ++i) {

				// convert d_size bytes to floating point
				float tmp = 0.0f;
				for (dword d = 0; d < d_size; ++d) {
					tmp *= 256.0f;
					byte c = *(data++);
					tmp += (float) c;
				}
				*(v_ptr++) = tmp;
				*(v_ptr++) = 0.0f;

			}
			v_ptr = pad(v_ptr, hiX);

		}
		v_ptr = pad(v_ptr, hiY * X);

	}
	v_ptr = pad(v_ptr, hiZ * X * Y);
}

void read_raw_r(ifstream& fin, byte* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size)
{
	if (!fin.is_open()) return;

	byte* v_ptr = vol;

	dword lowX = (X - XSize) / 2;
	dword lowY = (Y - YSize) / 2;
	dword lowZ = (Z - ZSize) / 2;

	dword hiX = X - lowX - XSize;
	dword hiY = Y - lowY - YSize;
	dword hiZ = Z - lowZ - ZSize;

	v_ptr = pad_r(v_ptr, lowZ * X * Y * d_size);
	for (dword k = 0; k < ZSize; ++k) {

		v_ptr = pad_r(v_ptr, lowY * X * d_size);
		for (dword j = 0; j < YSize; ++j) {

			v_ptr = pad_r(v_ptr, lowX * d_size);
			for (dword i = 0; i < XSize; ++i) {

				for (dword d = 0; d < d_size; ++d) {
					int c = fin.get();
					if (c < 0) cerr << "huh??\n";
					*(v_ptr++) = (byte) c;
				}

			}
			v_ptr = pad_r(v_ptr, hiX * d_size);

		}
		v_ptr = pad_r(v_ptr, hiY * X * d_size);

	}
	v_ptr = pad_r(v_ptr, hiZ * X * Y * d_size);
}

int read_head(ifstream& fin, dword& XSize, dword& YSize, dword& ZSize, dword& b_size)
{
	if (!fin.is_open()) return 0;

	char head[MAGIC_NUM_LEN];

	int i = 0;
	int c = fin.get();
	for (; (c!=' ') && (c!=10) && (c!=13); i++) {
		head[i] = c;
		c = fin.get();
	}
	head[i] = '\0';

	int ret = 0;
	if (strcmp(head, "PVP") == 0)
		ret = 1;
	else if (strcmp(head, "FVR") == 0)
		ret = 2;
	else
		return 0;

	XSize = readNumber(fin);
	YSize = readNumber(fin);
	ZSize = readNumber(fin);
	b_size = readNumber(fin);
	return ret;
}

bool write_pvp_head(ofstream& fout, dword XSize, dword YSize, dword ZSize, dword b_size)
{
	if (!fout.is_open()) return false;
	fout.write("PVP\n", 4);
	writeNumber(fout, XSize);
	writeNumber(fout, YSize);
	writeNumber(fout, ZSize);
	writeNumber(fout, b_size);
	return true;
}

bool write_fvr_head(ofstream& fout, dword XSize, dword YSize, dword ZSize, dword b_size)
{
	if (!fout.is_open()) return false;
	fout.write("FVR\n", 4);
	writeNumber(fout, XSize);
	writeNumber(fout, YSize);
	writeNumber(fout, ZSize);
	writeNumber(fout, b_size);
	return true;
}
 
} // end of namespace
