//
// Author: Steve Kilthau
// Date:   January 4, 2001
//

#ifndef _HWTIMER_H_
#define _HWTIMER_H_

#if defined(WIN32)
#include <windows.h>
#else
#include <sys/time.h>
#endif

//
// This class implements a basic hardware clock on systems
// that have hardware which support a high performance
// counter.
//
class HWTimer
{
public:
    //
    // Constructors and destructor.  If the system offers a
    // hardware clock, the default constructor sets up the
    // appropriate values.
    //
    HWTimer();
    HWTimer(HWTimer& t);
    ~HWTimer();

    //
    // Determines whether the system offers a hardware clock.
    //
    bool IsSupported(void);

    //
    // Gets the elapsed time since the last call to
    // GetElapsedTimeDouble/GetElapsedTimeFloat, or since
    // the return from the last call to SleepFloat/SleepDouble.
    //
    float GetElapsedTimeFloat(void);
    double GetElapsedTimeDouble(void);

    //
    // Causes the program to halt until s seconds have 
    // elapsed since the last call to GetElapsedTimeFloat,
    // GetElapsedTimeDouble, SleepFloat, or SleepDouble.
    // Before the function returns, the timer is updated.
    //
    void SleepFloat(float s);
    void SleepDouble(double s);

    //
    // Assignment operator.
    //
    HWTimer& operator=(HWTimer& rhs);

private:
#if defined(WIN32)
    LARGE_INTEGER  m_LastCount;
    float          m_FloatFreq;
    double         m_DoubleFreq;
#else
    struct timeval m_LastCount;
#endif
    bool           m_IsSupported;
};

#endif
