#ifndef _FILTER_H_
#define _FILTER_H_

#include "vuVector.h"
#include "vuSimpleTypes.h"

#define FILTER_TABLE_SIZE  20
#define FILTER_TABLE_MAX   19

namespace SpecFVRNS 
{
    
class Filter
{
public:
	inline Filter();
	inline Filter(Filter& f);
	virtual ~Filter();

	inline float* getWeights(vuVector& t);
	virtual dword getWidth(void) = 0;

	inline Filter& operator=(Filter& rhs);

protected:
	float* m_Weights;   // A table of weights
    dword m_FilterSize;
};

inline Filter::Filter() : m_Weights(0)
{
}

inline Filter::Filter(Filter& f)
{
}

inline Filter::~Filter()
{
    if (m_Weights) {
	delete [] m_Weights;
	m_Weights = NULL;
    }
}

inline Filter& Filter::operator=(Filter& rhs)
{
	return *this;
}

inline float* Filter::getWeights(vuVector& t)
{
	int i = (int)((t[0] * FILTER_TABLE_MAX) + 0.5);
	int j = (int)((t[1] * FILTER_TABLE_MAX) + 0.5);
	int k = (int)((t[2] * FILTER_TABLE_MAX) + 0.5);
	return &m_Weights[((k * FILTER_TABLE_SIZE + j) * FILTER_TABLE_SIZE + i) * m_FilterSize];
}
 
}

#endif
