#include "Transform.h"
#include <stdio.h>
#include <iostream>
#include <fftw.h>

using namespace std;
namespace SpecFVRNS 
{
    

#define WISDOM "fvr_fftw.wis"

static fftwnd_plan g_plan_2D;
static bool g_plan_exists = false;
static dword g_x3d;
static dword g_y3d;
static dword g_z3d;

void initTransforms(void)
{
	FILE* wisdom_file = fopen(WISDOM, "a+");
	if(!wisdom_file) {
	    cout<<"Could not load wisdom."<<endl;
	    return;
	}
	rewind(wisdom_file);
	fftw_import_wisdom_from_file(wisdom_file);
	fclose(wisdom_file);
}

void destroyTransforms(void)
{
	FILE* wisdom_file = fopen(WISDOM, "w");
	if(!wisdom_file) {
	    cout << "Could not save wisdom."<<endl;
	    return;
	}
	fftw_export_wisdom_to_file(wisdom_file);
	fclose(wisdom_file);
}

void initTransform2D(dword XSize, dword YSize)
{
    //destroyTransform2D();
    g_plan_2D = fftw2d_create_plan(YSize, XSize, FFTW_BACKWARD, FFTW_MEASURE | FFTW_IN_PLACE | FFTW_USE_WISDOM);
    g_plan_exists=true;
}

void transform2D(float* x)
{
    if(g_plan_exists)
	fftwnd_one(g_plan_2D, (fftw_complex*) x, 0);
    else cout << "no plan" << endl;
}

void destroyTransform2D(void)
{
    if(g_plan_exists) {
	fftwnd_destroy_plan(g_plan_2D);
	g_plan_exists = false;
    }
}

void initTransform3D(dword XSize, dword YSize, dword ZSize)
{
	g_x3d = XSize;
	g_y3d = YSize;
	g_z3d = ZSize;
}

void transform3D(float* x)
{
	fftwnd_plan p;
	p = fftw3d_create_plan(g_z3d, g_y3d, g_x3d, FFTW_FORWARD, FFTW_ESTIMATE | FFTW_IN_PLACE | FFTW_USE_WISDOM);
	fftwnd_one(p, (fftw_complex*) x, NULL);
	fftwnd_destroy_plan(p);
	dword size_i = g_z3d * g_y3d * g_x3d * 2;
	float size_f = (float) g_z3d * g_y3d * g_x3d;
	for (dword i = 0; i < size_i; ++i)
		x[i] /= size_f;
}

void destroyTransform3D(void)
{
	g_x3d = 0;
	g_y3d = 0;
	g_z3d = 0;
}

void shift3D(float* x, dword XSize, dword YSize, dword ZSize)
{
	dword xstep;
	dword ystep;
	dword i;
	dword j;
	dword k;
	dword index1;
	int start1 = 0;
	int val1   = -1;
	dword index2;
	int start2;
	int val2;

	xstep = XSize * 2;
	ystep = YSize * XSize * 2;

	index1 = 0;
	for(k = 0; k < ZSize; ++k)
	{
		index2 = index1;
		start2 = start1;
		val2   = val1;
		for(j = 0; j < YSize; ++j)
		{
			for(i = start2; i < xstep; i += 4)
			{
				x[index2+i]   *= -1.0f;
				x[index2+i+1] *= -1.0f;
			}
			val2 *= -1;
			start2 += val2*2;
			index2 += xstep;
		}
		val1 *= -1;
		start1 += val1*2;
		index1 += ystep;
	}
}

void shift2D(float* x, dword XSize, dword YSize)
{
	dword xstep;
	dword i;
	dword j;
	dword index;
	int start = 0;
	int val = -1;

	xstep = XSize * 2;

	index = 0;
	for (j = 0; j < YSize; ++j) {
		for (i = start; i < xstep; i += 4) {
			x[index+i]   *= -1.0f;
			x[index+i+1] *= -1.0f;
		}
		val *= -1;
		start += val * 2;
		index += xstep;
	}
}

void shift_copy2D(float* dest, float* src, dword XSize, dword YSize)
{
	dword i, j;
	dword xlast = XSize / 2;
	dword ylast = YSize / 2;

	float* src_ptr = src;
	float* dest_ptr = dest;

	for (j = 0; j < ylast; ++j) {
		for (i = 0; i < xlast; ++i) {
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
			*(dest_ptr++) = *(src_ptr++);
			*(dest_ptr++) = *(src_ptr++);
		}
		for (i = 0; i < xlast; ++i) {
			*(dest_ptr++) = *(src_ptr++);
			*(dest_ptr++) = *(src_ptr++);
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
		}
	}
}
 
}
