// Author:	Steven Bergner
// Created:	Jan02

#ifndef _VUVOLUMEREGULARUNIMODAL3D1B1VALSLICER_H_
#define _VUVOLUMEREGULARUNIMODAL3D1B1VALSLICER_H_

#include "../intensity.h"
#include "vuSimpleTypes.h"
#include "vuImage.h"

class vu1112116;
typedef vu1112116 vuVolumeRegularUnimodal3d1B1ValSlicer;
/** This is a simple slicer
    Nicetohave: display corresponding slices along all axes at the same time,
		Animation


    long name: vuVolumeRegularUnimodal3d1B1ValSlicer
    \author Steven Bergner
*/
class vu1112116 : public vu111211
{
public:

    //!Default constructor creating an empty instance.
    vu1112116();
    //!Copy constructor which does a deep copy.
    vu1112116(const vu1112116& inst);
    //!Destructor.
    virtual ~vu1112116();

    //!Assignment operator which does a deep copy.
    vu1112116& operator=(const vu1112116& rhs);

    //!Initializes open gl for rendering the volume data.
    void initOpenGL(void);
    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();

    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

    //! set size of the canvas to render to
    void setImageSize(dword sx, dword sy);

    //! sets current position
    void setPosition(const vuVector & pos)
	{
	    if(isInside(pos))
	       m_Position = pos;
	};

    //! sets current position
    void getPosition(vuVector & pos)
	{ pos = m_Position;};
    
    //! returns value at given position
    dword getValue(const vuVector & where);

    /** returns a pointer to the byte at position 'where'
	\return NULL if isInside(where) is false */
    byte* getDataPointer(const vuVector & where);

    //! true if point lies inside the volume
    bool isInside(const vuVector& pos);

    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right) {};
    
 protected:
    vuImage 		m_Image;	//!< image (just an RGB byte framebuffer)
    vuVector		m_Position;	//!< point the slices for each axis go through
    float		m_ImgScaleX, m_ImgScaleY; //!< Scaling the image
};

#endif
