#include <iostream>
#include <fstream>

#include "vuColourRGBa.h"

#include "Slicer.h"

#define min(a,b) (a<b ? a : b)

//----------------------------------------------------------------------------
//------------------------- The default constructor --------------------------
//----------------------------------------------------------------------------

vu1112116::vu1112116() : m_Position(0,0,0), m_ImgScaleX(1), m_ImgScaleY(1)
{
}

//----------------------------------------------------------------------------
//------------------------- The copy constructor -----------------------------
//----------------------------------------------------------------------------

vu1112116::vu1112116(const vu1112116& inst) : vu111211(inst)
{
    m_Position = inst.m_Position;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vu1112116::~vu1112116()
{
}

//----------------------------------------------------------------------------
//------------------------- The assignment operator --------------------------
//----------------------------------------------------------------------------

vu1112116& vu1112116::operator=(const vu1112116& rhs)
{
    if (this != &rhs)
    {
        vu111211::operator=(rhs);
    }
    return *this;
}

//----------------------------------------------------------------------------
void vu1112116::setImageSize(dword sx, dword sy)
{
    m_ImgScaleX = (float)sx/m_Dim1Size;
    m_ImgScaleY = (float)sy/m_Dim2Size;
#ifdef QUADRATIC_WIN
    if(m_ImgScaleX > m_ImgScaleY) m_ImgScaleX = m_ImgScaleY;
    else if(m_ImgScaleY > m_ImgScaleX) m_ImgScaleY = m_ImgScaleX;
#endif
    
    glPixelZoom(m_ImgScaleX, m_ImgScaleY);
    //m_Image.init(sx,sy); we leave the image as it is
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(0,sx,0,sy,-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}

void vu1112116::initOpenGL(void)
{
    //glEnable(GL_SECRET_FEATURE);
}

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu1112116::read()
{
    bool success = vu111211::read();
    if (!success) return false;

    m_Image.init(m_Dim1Size,m_Dim2Size);

    return true;
}

//----------------------------------------------------------------------------
//------------------------- public readRaw() ---------------------------------
//----------------------------------------------------------------------------

bool vu1112116::readRaw(void)
{
    dword len;
    ifstream in;

    in.open(m_FileName, ios::in|ios::binary
#ifdef IS_NOCREATE_NEEDED
|ios::nocreate
#endif
);
    if (!in.is_open()) return false;

    in.seekg(0, ios::end);
    len = in.tellg();
    in.seekg(0, ios::beg);

    in >> m_Dim1Size >> m_Dim2Size >> m_Dim3Size;
    if (in.fail()) return false;
    m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;

    m_Data = new byte[m_DataSize];
    in.read((char *)m_Data, (int)m_DataSize);
    if (in.fail()) return false;

    in.close();

    m_Image.init(m_Dim1Size,m_Dim2Size);
    setImageSize(m_Dim1Size,m_Dim2Size);

    return true;
}

//----------------------------------------------------------------------------
//------------------------- public render() ----------------------------------
//----------------------------------------------------------------------------
#define USE_TFUNC
void vu1112116::render(void)
{
  byte tfunc[256][3];
#ifdef USE_TFUNC
  for(int i=0;i<256;i++)
  {
      tfunc[i][0] = byte(255*m_TFunc[i][0]);
      tfunc[i][1] = byte(255*m_TFunc[i][1]);
      tfunc[i][2] = byte(255*m_TFunc[i][2]);
  }
#else
  for(int i=0;i<256;i++)
  {
      tfunc[i][0] = i;
      tfunc[i][1] = i;
      tfunc[i][2] = i;
  }
#endif
  
  
  dword mx,my;
  m_Image.get_extents((int&)mx,(int&)my);
  dword sx = min(mx,m_Dim1Size);
  dword sy = min(my,m_Dim2Size);
  dword addimg=0, addvol=0;
  if(sx<mx) addimg = 3*(mx-sx);
  else addvol = sx-mx;

  byte *image = (byte*)m_Image.get_rgb();
  byte *data = getDataPointer(vuVector(0,0,m_Position[2]));

  if(data)	// inside cube?
  {
      for(dword y=0;y<sy;y++,image+=addimg, data+=addvol)
	  for(dword x=0;x<sx;x++,data++)
	  {
	      *(image++)=tfunc[*data][0];
	      *(image++)=tfunc[*data][1];
	      *(image++)=tfunc[*data][2];
	  }
  }

  //copy to screen
  if(mx && my) {
      glClear(GL_COLOR_BUFFER_BIT);
      //glPixelZoom(m_ImgScaleX, m_ImgScaleY);
      m_Image.blit();
  }
}

dword vu1112116::getValue(const vuVector & where)
{
    if(isInside(where))
	return m_Data[dword(where[0]/m_ImgScaleX)
		      + dword(where[1]/m_ImgScaleY)*m_Dim1Size
		      + dword(where[2])*m_Dim1Size*m_Dim2Size];
    else return 0;
}

byte* vu1112116::getDataPointer(const vuVector & where)
{
    if(isInside(where))
	return &m_Data[dword(where[0]/m_ImgScaleX)
		      + dword(where[1]/m_ImgScaleY)*m_Dim1Size
		      + dword(where[2])*m_Dim1Size*m_Dim2Size];
    else return NULL;
}

bool vu1112116::isInside(const vuVector& pos)
{
    return (pos[0]>=0 && pos[0]/m_ImgScaleX<m_Dim1Size &&
	    pos[1]>=0 && pos[1]/m_ImgScaleX<m_Dim2Size &&
	    pos[2]>=0 && pos[2]<m_Dim3Size);
}

