#ifndef _SLICERIMAGE_H_
#define _SLICERIMAGE_H_

#include "vuSimpleTypes.h"
#include "vuColourRGBa.h"

namespace ns_vu1112116 {

/** Hold a spectrum for each pixel on the screen. 
    Is used to apply post-illumination.
    The reference to ColourType is a typecast that stands for 
    the color model used in the currently compiled version.
   \todo relate it more to the framebuffer provided by a future version
   of vuDrawTools
 */
class Image  
{
public:
	/** constructor */
	Image();
	/** destructor */
	virtual ~Image();
	/** initialize spectral framebuffer of given size */
	bool init(int sizx, int sizy);
	/** get extents of image */
	void get_extents(int & sizx, int & sizy);
	/** set spectral color information for a point */
	bool set_xy(int x, int y, const vuColourRGBa& col);
	/** get colour from specific point 
	    \return false if xy out of range */
	bool get_xy(int x, int y, vuColourRGBa & col);
	/** returns the framebuffer */
	const byte* get_rgb() const;
private:
	/** pointer to spectral frame buffer */
	byte *spix;
	/** extents of the framebuffer */
	int maxx,maxy;
};

};

#endif
