// Image.cpp: Implementierung der Klasse Image.
//
//////////////////////////////////////////////////////////////////////
#include <stddef.h>
#include "Image.h"

using namespace ns_vu1112116;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

Image::Image()
{
  spix = NULL;
  init(0,0);
}

Image::~Image()
{
	if(spix) delete [] spix;
}

bool Image::init(int sizx, int sizy)
{
  maxx=sizx;
  maxy=sizy;
  if(spix) delete [] spix;
  if(sizx && sizy)
    {
      spix = new byte[maxx*maxy*3];
      if(!spix) return false;
    } else spix = NULL;
  return true;
}

bool Image::set_xy(int x, int y, const vuColourRGBa& col)
{
	if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	vuColourRGBa rgb(col);
	rgb.clampTo01();
	byte *pix = &spix[(x+maxx*y)*3];
	pix[0] = byte(255.0f * rgb[0]);
	pix[1] = byte(255.0f * rgb[1]);
	pix[2] = byte(255.0f * rgb[2]);
	return true;
}

bool Image::get_xy(int x, int y, vuColourRGBa &col)
{
	if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	col = spix[x+maxx*y];
	return true;
}

const byte* Image::get_rgb() const
{
  return spix;
}

void Image::get_extents(int &sizx, int &sizy)
{
	sizx=maxx;
	sizy=maxy;
}
