#ifndef _vu1112119_H_
#define _vu1112119_H_

#include "../intensity.h"
#include "vuFourierVolume_IO.h"

class vu1112119;
typedef vu1112119 vuVolumeRegularUnimodal3d1B1SimpleFVR;

class vu1112119 : public vu111211, public vuFourierVolume_IO<1>
{
public:
    vu1112119();
    ~vu1112119();

    byte *getData();
    //! update the camera (since the camera is only stored in vu111211)
    void updateCamera();

    void setCamera(vuCamera *camera);

    void setViewVectors(const vuVector& view, 
			const vuVector& up,
			const vuVector& right);

    //!Reimplements the read() method to do some extra volume data processing.
    //!\param imageSize specifies the imageSize (width=height)
    virtual bool read();

    virtual void glResize(dword height, dword width);
    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    vuVector getCenter();

    static bool convertVUD2VUF(vuString inputFile, vuString outputFile,
			       float mult_pad=M_SQRT2, float add_pad=0,
			       float scale=1.0f, vuTFIntensity *tf=NULL);
    static bool convertVUF2VUD(vuString inputFile, vuString outputFile,
			       float scale);

};
#endif
