#include "vuSimpleFVR.h"
#include "vuSimpleTypes.h"

vu1112119::vu1112119()
{
}

vu1112119::~vu1112119()
{
  vu1::m_Camera = NULL;
}

byte *vu1112119::getData()
{
  return m_Data;
}

bool vu1112119::read()
{
  if (!vu111211::read()) {
    cerr << "could not read spatial domain volume" << endl;
    return false;
  }
  bool result=preprocessSpatialInput(m_Data,m_Dim1Size,m_Dim2Size,m_Dim3Size);

  CHECKNDELETE(m_Data);
  return result;
}

void vu1112119::glResize(dword width, dword height)
{
  if (m_ImageXSize && m_ImageYSize && width && height) {
    glPixelZoom((float)width/m_ImageXSize, (float)height/m_ImageYSize);
  }
  else {
    cerr << "vu1112119.glResize(): no m_ImageXSize/m_ImageYSize set." << endl;
    glPixelZoom(1.0f, 1.0f);
  }
}

void vu1112119::render()
{
  if (m_Volume) {
    vuFourierVolume1::setCamera(vu111211::getCameraPtr());
    computeSlice();
    // ????_???_???
    cerr << "vuSimpleFBR::render is not implemented" << endl;
#if 0
    glDrawPixels(getImageWidth(),
		 getImageHeight(),
		 GL_LUMINANCE,
		 GL_FLOAT,
		 getImageData());
#endif
  }
}

void vu1112119::updateCamera()
{
  vuFourierVolume1::setCamera(vu111211::getCameraPtr());
}

void vu1112119::setCamera(vuCamera *camera)
{
  vuFourierVolume1::setCamera(camera);
  vu111211::setCamera(camera);
}

void vu1112119::setViewVectors(const vuVector& view,
			       const vuVector& up,
			       const vuVector& right)
{
  vuFourierVolume1::setViewVectors(view, up, right);
}

vuVector vu1112119::getCenter()
{
  return vuVector(0,0,0);
}


bool vu1112119::convertVUD2VUF(vuString inputFile, vuString outputFile,
			       float mult_pad, float add_pad, float scale,
			       vuTFIntensity *tf)
{
  vu1112119 *volume = new vu1112119();

  volume->setFileName(inputFile);
  if (!volume->vu111211::read()) {
    cerr << "could not read vud file" << endl;
    CHECKNDELETE(volume);
    return false;
  }

  dword SIZE     = (tf == NULL) ? 1 : 3;
  dword dim1     = volume->getDim1Size();
  dword dim2     = volume->getDim2Size();
  dword dim3     = volume->getDim3Size();
  dword len      = dim1 * dim2 * dim3;
  byte *spatData = new byte[len * SIZE];
  byte *d_ptr    = spatData;

  if (tf != NULL) {
    byte *s_ptr = volume->getData();

    vuColourRGBa colour;
    tf->normalizeAlphaToOne();

    for (dword j=0; j<len; j++) {
      tf->getRGBa(*(s_ptr++), colour);
      for (dword i=0; i<SIZE; i++) {
	*(d_ptr++) = (byte)(255 * colour[i]);
      }
    }
  }
  else {
    byte *s_ptr = volume->getData();
    for (dword i=0; i<len; i++) *(d_ptr++) = *(s_ptr++);
  }

  CHECKNDELETE(volume);
  
  {
    bool result;

    switch (SIZE) {
      case 1: {
	vuFourierVolume_IO<1> fourierVolume;
	fourierVolume.preprocessSpatialInput(spatData, dim1, dim2, dim3,
					     1.0, M_SQRT2, 0, false);
	CHECKNDELETE(spatData);
	result = fourierVolume.scaleAndWriteToFourierFile(outputFile, scale);
	break;
      }
      case 3: {
	vuFourierVolume_IO<3> fourierVolume;
	fourierVolume.preprocessSpatialInput(spatData, dim1, dim2, dim3,
					     1.0, M_SQRT2, 0, false);
	CHECKNDELETE(spatData);
	result = fourierVolume.scaleAndWriteToFourierFile(outputFile, scale);
	break;
      }
      default: cerr << "vuSimpleFVR::convertVUD2VUF() case not implemented!";
               cerr << endl;
               return false;
    };
    return result;
  }
}

bool vu1112119::convertVUF2VUD(vuString inputFile, vuString outputFile,
			       float scale)
{
  byte *volume = NULL;
  dword XSize, YSize, ZSize;
  bool  status;

  status = vuFourierVolume_IO<1>::getSpatialDataFromVUF(volume,
							XSize, YSize, ZSize,
							scale, inputFile);
  if (status) {
    vu11121 spatialVolume(volume, XSize, YSize, ZSize);

    spatialVolume.setFileName(outputFile);
    spatialVolume.write();
  }
  else {
    CHECKNDELETE(volume);
  }
  return status;
}

#if 0
bool vu1112119::writeFrequencyData2VUD(float *freqData, vuString outputFile)
{
  byte *volume = NULL;
  dword XSize, YSize, ZSize;
  bool  status;

  status = vuFourierVolume_IO<1>::getSpatialDataFromVUF(volume,
							XSize, YSize, ZSize,
							scale, inputFile);
  if (status) {
    vu11121 spatialVolume(volume, XSize, YSize, ZSize);

    spatialVolume.setFileName(outputFile);
    spatialVolume.write();
  }
  else {
    CHECKNDELETE(volume);
  }
  return status;
}
#endif
