#ifndef _Volume_Regular_Unimodal_SimpleFVR_vuFourierVolume_IO_H_
#define _Volume_Regular_Unimodal_SimpleFVR_vuFourierVolume_IO_H_

#include "../intensity.h"
#include "General/vuFourier/vuFourierVolume.h"

template <int S>
class vuFourierVolume_IO : public vuFourierVolume<S>
{
 protected:
  using vuFourierVolume<S>::m_Volume;
  using vuFourierVolume<S>::m_XSize;
  using vuFourierVolume<S>::m_YSize;
  using vuFourierVolume<S>::m_ZSize;
  using vuFourierVolume<S>::m_Wrap;
 public:
  using vuFourierVolume<S>::computeDimensions;
  using vuFourierVolume<S>::setWrap;
  using vuFourierVolume<S>::wrapAndInitialize;
 public:
  virtual ~vuFourierVolume_IO() {};
  //! returns a scaled frequency volume
  bool scaleAndWriteToFourierFile(const char *fileName, float scale);

  //! reads the spatial domain volume data with size XSize, YSize, ZSize
  //! and transforms it into an fourier volume
  bool preprocessSpatialInput(byte *data,
			      dword XSize, dword YSize, dword ZSize,
			      float s=1.0,
			      float mult_pad=M_SQRT2,
			      dword add_pad=0,
			      bool doWrapAndInit=true);

  void preprocess();
  static void transform3D(float* data, dword xx, dword yy, dword zz);
  static void inverseTransform3D(float* vol, dword xx, dword yy, dword zz);
  static void shift3D(float* data, dword XSize, dword YSize, dword ZSize);
  static float* pad(float* v, dword n);

  /* read spatial data and transfrom it into a complex representation,
     which is still in spatial domain. Some padding is done as well.  */
  static void readSpatial(byte *in, float* out,
			  dword XX, dword YY, dword ZZ,
			  dword XXsmall, dword YYsmall, dword ZZsmall);

  static bool getSpatialDataFromVUF(byte *&volume, dword &XSize,
				    dword &YSize, dword &ZSize,
				    float scale, vuString fileName);

  /* pads an existing fourier volume. This is a preprocessing step
     for the wrapping */
  static void padFourier(float *in, float* out,
			 dword XX, dword YY, dword ZZ,
			 dword XXsmall, dword YYsmall, dword ZZsmall);
};

template class vuFourierVolume_IO<1>;
template class vuFourierVolume_IO<2>;
template class vuFourierVolume_IO<3>;

#endif /* _Volume_Regular_Unimodal_SimpleFVR_vuFourierVolume_IO_H_ */
