#ifndef _VUSAMPLERAY_H_
#define _VUSAMPLERAY_H_

#include "vuVector.h"
#include "vuRay.h"
#include "DatGrid.h"
#include "DatPnt.h"

namespace ns_vu1112113 {

//! Defines a Ray using the direction vector as sampling step.
/*! Derived from the vuRay class and adds a feature to change position by
  a certain sampling step, keeping track of current position in Grid.
  Because of its orientation to specific grid type probably not a general tool.
 */
class vuSampleRay : public vuRay
{
    friend class DatGrid;
public:
    //! Default constructor
    vuSampleRay();
    vuSampleRay(const vuSampleRay &r);    //!< Copy constructor
    vuSampleRay(const vuRay &r);    //!< Copy constructor for simple vuRay
    ~vuSampleRay();               //!< Destructor

    void SamplingDistance(float sd);	//!< modifies length of direction vector to sd
    float SamplingDistance() const;		//!< returns current sampling distance 

    //! Assignment operator
    vuSampleRay& operator=(vuSampleRay &rhs);

    bool advanceRay();

    /** get sampled point for current position
	\return interpolated density (precise version of dat.data)
     */
    float getSamplePoint(DatPnt& dat, bool getnormal = true) const;

    bool attachToGrid(const DatGrid& grid);
    
protected:
    float	  m_SmpDist;			//!< sampling distance (length of direction vector)

    const DatGrid *m_Grid;			//!< grid ray is within
    int		  grid_index;
    int		  gridPos[3];			//!< location in grid
    int		  axis[3];			//!< [0] is ID of predominant axis, [1] and [2] are 
    int		  step[3];			//!< forward/backward steps (1 or -1)
    float	  incr[2][2];			//!< increments for chosen direction
    float	  dist[3];			//!< not used
    int		  maxSmp, numSmp;		//!< total and current number of samples

    int		  m_Side, m_InSide;		//!< side IDs for leaving and entering the data cube

    int			steps;			// number of samples until leaving the grid
    
    DatPnt		*cell[8];
    float		w[8];			// weights for triliniar interpolation
    int			p[3];			// indexed position in the grid (for cell[0])
    float		t[3];			// components are between 0 and 1
};

};

#endif
