#include <iostream>
#include <fstream>
#include <math.h>

#include "vuColourRGBa.h"
#include "vuCamera/vuParallelCamera.h"
#include "vuCamera/vuPerspectiveCamera.h"

#include "Raycast.h"

//#define SPRC_SINGLEPROCESS	// force single process rendering

//!do a correction of the alpha for varying sampling distance
#define DO_EXPALPHA
/** Since we use 1-exp(-alpha*smpdist*EXPALPHA) it is not possible to reach
    opacity values of one. 'alpha' is restricted to [0,1], the EXPALHA coefficient
    helps to enlarge this interval. */
#define EXPALPHA	3
#define SHININESS       10
#define GLOSS           0.2
//----------------------------------------------------------------------------
//------------------------- The default constructor --------------------------
//----------------------------------------------------------------------------

vu1112113::vu1112113() : lightdir(1,0,0), m_Specular(1,1,1,0)
{
  m_Camera = new vuPerspectiveCamera();
  m_Camera->setHeight(240);
  m_Camera->setWidth(320);
  diffuse            = 1.f;
  brightness         = .5f;
  m_PreDraw          = false;
  m_DoSpecular       = false;
  m_SamplingDistance = 1.0f;
}

//----------------------------------------------------------------------------
//------------------------- The copy constructor -----------------------------
//----------------------------------------------------------------------------

vu1112113::vu1112113(const vu1112113& inst) : vu111211(inst)
{
  lightdir = inst.lightdir;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vu1112113::~vu1112113()
{
  if (m_Camera != NULL) {
    delete m_Camera;
    m_Camera = NULL;
  }
}

//----------------------------------------------------------------------------
//------------------------- The assignment operator --------------------------
//----------------------------------------------------------------------------

vu1112113& vu1112113::operator=(const vu1112113& rhs)
{
    if (this != &rhs)
    {
        vu111211::operator=(rhs);
    }
    m_rerendering = false;
    return *this;
}

//----------------------------------------------------------------------------
void vu1112113::setImageSize(dword sx, dword sy)
{
  if (m_Camera->getType() == vuCamera::vuPERSPECTIVE_CAMERA) {
    vuPerspectiveCamera *cptr = (vuPerspectiveCamera *)m_Camera;
    cptr->setAspect(float(sx)/sy);
  }
  m_Camera->setWidth(sx);
  m_Camera->setHeight(sy);
  m_Camera->init();
  m_Image.init(m_Camera->getWidth(),m_Camera->getHeight());
}

void vu1112113::getImageSize(dword &sx, dword &sy)
{
  sx = m_Camera->getWidth();
  sy = m_Camera->getHeight();
}

//----------------------------------------------------------------------------
//------------------------- public setViewVectors() --------------------------
//----------------------------------------------------------------------------

void vu1112113::setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right)
{
  m_Camera->setLookAtVector(view);
  m_Camera->setUpVector(up);
  // m_Camera->setRightVector(right);
  m_Camera->init();
}

/*
void vu1112113::setViewVectors(const vuVector& pos,const vuVector& vrp,const vuVector& up)
{
	m_Camera->setPosition(pos);
	m_Camera->setLookAtVector(pos+vrp);
	m_Camera->setUpVector(up);
	m_Camera->init();
}
*/

//----------------------------------------------------------------------------
//------------------------- public initOpenGL() ------------------------------
//----------------------------------------------------------------------------

void vu1112113::initOpenGL(void)
{
    glDisable(GL_LIGHTING);
}

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu1112113::read()
{
    bool success = vu111211::read();
    if (!success) return false;

    m_Grid.copy_vol(m_Data, *this);
    center=vuVector((float)m_Dim1Size/2,(float)m_Dim2Size/2,(float)m_Dim3Size/2);
    m_Camera->setPosition(center);
    m_Camera->translateXYZ(0,0,-(float)m_Dim1Size);
    m_Camera->init();

    m_rerendering = false;
    pp_gradients  = false;
    preprocess();
    return true;
}

//----------------------------------------------------------------------------
//------------------------- public readRaw() ---------------------------------
//----------------------------------------------------------------------------

bool vu1112113::readRaw(void)
{
    dword len;
    ifstream in;

    in.open(m_FileName, ios::in|ios::binary
#ifdef IS_NOCREATE_NEEDED
|ios::nocreate
#endif
);
    if (!in.is_open()) return false;

    in.seekg(0, ios::end);
    len = in.tellg();
    in.seekg(0, ios::beg);

    in >> m_Dim1Size >> m_Dim2Size >> m_Dim3Size;
    if (in.fail()) return false;
    m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;

    m_Data = new byte[m_DataSize];
    in.read((char *)m_Data, (int)m_DataSize);
    if (in.fail()) return false;

    in.close();

    m_Grid.copy_vol(m_Data, *this);
    center=vuVector((float)m_Dim1Size/2,(float)m_Dim2Size/2,(float)m_Dim3Size/2);
    m_Camera->setPosition(center);
    m_Camera->translateXYZ(0,0,-(float)m_Dim1Size);
    m_Camera->init();
    m_rerendering = false;
    pp_gradients  = false;
    preprocess();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- private preprocess() -----------------------------
//----------------------------------------------------------------------------

void vu1112113::preprocess(void)
{
  // compute normals
  if(!pp_gradients)
    {
      cout<<"computing normals..."<<endl;
      m_Grid.calculate_gradients();
      m_Grid.shade(*this);
      pp_gradients=true;
    }
}

//----------------------------------------------------------------------------
void vu1112113::run(int whatsup, void* data)
{
  //cout<<"running as "<<whatsup<<endl;
  //shootRays(whatsup,2);
  dword oddheight = m_Camera->getHeight()-1;

  if(!(oddheight & 0x01)) oddheight--;
  if(whatsup)
    shootRays(0,1,oddheight,-2);
  else
    shootRays(0,1,0,2);
  
  m_Mutex[whatsup].unlock();
}


//----------------------------------------------------------------------------
//------------------------- public render() ----------------------------------
//----------------------------------------------------------------------------

void vu1112113::render(void)
{
    //OpenGL is already prepared to draw 2D on an Ortho screen
  vuVector pos = m_Camera->getPosition();
  vuVector dir = m_Camera->getLookAtVector();

  if(m_rerendering)
    {
	m_TFuncPI = m_TFunc;
	
	
#ifdef SPRC_SINGLEPROCESS
	shootRays();
#else
	m_Mutex[0].lock();	// will be unlocked by thread 0
	m_Mutex[1].lock();	// will be unlocked by thread 1
	
	if(startThread(0))
	{
		startThread(1);
	} else shootRays();

	m_Mutex[0].lock();
	m_Mutex[1].lock();
	m_Mutex[0].unlock();
	m_Mutex[1].unlock();
#endif
	m_rerendering = false;
    }

  // This method is for computation only, not for displaying!!! -ms-
  //int mx,my;
  //m_Image.get_extents(mx,my);
  //copy to screen
  //if(mx && my) {
  //   m_Image.blit();
  //}
}

//----------------------------------------------------------------------------
void vu1112113::shootRays(int xofs, int xinc, int yofs, int yinc)
{
    m_Image.init(m_Camera->getWidth(), m_Camera->getHeight());
    int i,j;
    int w = m_Camera->getWidth();
    int h = m_Camera->getHeight();
    glBegin(GL_POINTS);
    for(j=yofs;j<h && j>=0;j+=yinc)
    {
	for(i=xofs;i<w;i+=xinc)
	{
	    vuSampleRay ray(m_Camera->getRay((float)i,(float)j));
	    vuColourRGBa col = Cast(ray);
	    
	    m_Image.set_xy(i,h-j, col);

	    if(!yofs && m_PreDraw) {
		col.clampTo01();
		col.glColor();
		glVertex2i(i,h-j);	// coordinate system is upside down
	    }
	    
	}
    }
    glEnd();
}

//----------------------------------------------------------------------------
// Cast a ray through the grid
vuColourRGBa vu1112113::Cast(vuSampleRay& Sray)
{
        Sray.SamplingDistance(m_SamplingDistance);
	if(!Sray.attachToGrid(m_Grid)) return m_Background;
	vuColourRGBa colour(0.0f);
	int steps=1;
	bool terminate = false;
	DatPnt sample;
	float aalpha = 1;		// 1 - accumulated alpha
	float lastvalue = 0;
	while(!terminate && Sray.advanceRay())
	{
	    // get the interpolated value
	    //float fdensity = rint(Sray.getSamplePoint(sample, m_DoSpecular));
	    float fdensity = Sray.getSamplePoint(sample, m_DoSpecular);
	    //use the position information
	    
	    vuColourRGBa scol;
	    if(m_TFuncMethod == TFUNC_SMP)
		scol = m_TFunc[sample.data];
	    else
		m_TFuncPI.integrate(lastvalue,fdensity,m_SamplingDistance, scol);
	    if(scol.getAlpha() > 0.001)
	    {
#ifdef DO_EXPALPHA
		scol.setAlpha(1-exp(-scol.getAlpha()*m_SamplingDistance*EXPALPHA));
#endif		
		scol *= sample.illum;
		if(m_DoSpecular && sample.len>2)
		{
		    vuVector normal = sample.normalVec();
		    vuVector r(Sray.m_Direction);
		    r -=  2*normal*normal.dot(r);
		    r.makeUnit();
		    float spec=r.dot(lightdir);
		    if(spec>0)
		    {
			spec=(float)pow((r.dot(lightdir)),SHININESS)*GLOSS;
			scol += m_Specular*spec;
		    }
		}
		
		colour += scol*(scol.getAlpha()*aalpha);
		aalpha *= 1-scol.getAlpha();
		
		if(aalpha<0.05)
		    terminate = true;
	    }
	    steps++;
	    lastvalue = fdensity;
	} //end of while
	if(!terminate) 
	  colour += m_Background*aalpha;
	return colour;
}

/*
void vu1112113::adjust_camera(float px, float py, float pz, float ux, float uy, float uz)
{
  m_Camera->setPosition(vuVector(px,py,pz));
  m_Camera->setUpVector(vuVector(ux,uy,uz));
  m_Camera->Init();
}

bool vu1112113::get_extents(int &mx, int &my, int &mz)
{

	mx = Grid.m_Dim1Size;
	my = Grid.m_Dim2Size;
	mz = Grid.m_Dim3Size;
	return true;
}
*/

void vu1112113::doRefresh()
{
  m_rerendering = true;
}

vuVector vu1112113::getCenter() const
{
  return center;
}


/*-------------------------------------------------
Functions required by vuKeyFramer
---------------------------------------------------*/

vuImage* vu1112113::getImage ()

{
	return &m_Image;
}

void vu1112113::displayFromImage ()

{
  int mx, my;

  m_Image.get_extents (mx, my);

  if(mx && my)
      m_Image.blit();
  else
    cout << "bad" << endl;
}

