// DatPnt.h: Schnittstelle fr die Klasse DatPnt.
//
//////////////////////////////////////////////////////////////////////
#ifndef _DATPNT_H_
#define _DATPNT_H_

#include "vuSimpleTypes.h"
#include "vuVector.h"

class vu1112113;

namespace ns_vu1112113 {

/** Class containing information about a single grid point. 
    Instances of this class are managed inside the according geometry by DatGrid.
*/
class DatPnt  
{
public:
	/** constructor */
	DatPnt();
	/** destructor */
	~DatPnt();

	/** reset class information */
	void reset();

	/** precompute diffuse illumination */
	void shade(vu1112113 &r);

	//! get normal (gradient) as vuVector
	const vuVector normalVec() const {return vuVector(norm);} 

	void  setNormalVec(const vuVector& nv) {
	    norm[0] = nv[0];
	    norm[1] = nv[1];
	    norm[2] = nv[2];
	}

	/** the data byte for the point  
	    it would be better to refer to the original dataset. But for the current
	    implementation a reference takes more time. */
	byte			data;
	byte			len;	//!< original length of gradient
	float		        norm[3];	//!< normal (normalized inverted central differences)
	float			illum;	//!< precomputed illumination3
};

};	//end of namespace
#endif
