// DatGrid.cpp: Implementierung der Klasse DatGrid.
//
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <math.h>

#include "Raycast.h"
#include "DatGrid.h"
#include "vuSampleRay.h"

#define RET_OK	 0
#define RET_ERR	-1

#define TOLERANCE	0.001

// Check if value is within TOLERANCE of zero.  If it
// is then make value equal to zero.
static float SnapToZero(float t)
{
  return (fabs(t)<TOLERANCE)?(float)(0.0):t;
}

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

DatGrid::DatGrid()
{
  maxX=maxY=maxZ=layXY = 0;
  vol = NULL;
}

DatGrid::~DatGrid()
{
  free_vol_mem();
}

int DatGrid::free_vol_mem()
{
  if(vol)
    {
      delete [] vol;
      vol = NULL;
    }
  
  return RET_OK;
}

// allocates memory according to axis extents
int DatGrid::get_vol_mem()
{
  free_vol_mem();
  vol = new DatPnt[maxX*maxY*maxZ];
  if(!vol) return RET_ERR;
  else return RET_OK;
}

// initialises the grid
int DatGrid::init(int maxx, int maxy, int maxz)
{
  maxX = maxx; maxY = maxy; maxZ = maxz;
  layXY = maxX*maxY;
  size = layXY*maxZ;
  m_C0 = vuVector(0.0);
  m_C1 = vuVector((float)maxx-1,(float)maxy-1,(float)maxz-1);
  return get_vol_mem();
}

float DatGrid::clipRay(vuSampleRay &r, bool bidirectional, int& m_Side) const
{
    vuVector pos;
    vuVector dir;
    float X;
    float Y;
    float Z;
    float tMin=0;
    float t;

    m_Side = -1;

    pos = r.m_Position;
    dir = r.m_Direction;

    // m_Side == 6 if rendering within the volume
    if( bidirectional &&
        (pos[0] > m_C0[0]) && (pos[0] < m_C1[0]) &&
        (pos[1] > m_C0[1]) && (pos[1] < m_C1[1]) &&
        (pos[2] > m_C0[2]) && (pos[2] < m_C1[2]) )
      {
        m_Side = 6;
        return t = 0;
      }

    // Test the X0 wall
    t = SnapToZero((m_C0[0] - pos[0]) / dir[0]);
    if (t > 0)
    {
        Y = pos[1] + t * dir[1];
        Z = pos[2] + t * dir[2];
        if ((Y >= m_C0[1]) && (Y <= m_C1[1]) &&
            (Z >= m_C0[2]) && (Z <= m_C1[2]) &&
			(bidirectional || t>=0))
        {
            tMin = t;
            m_Side = 0;
        }
    }

    // Test the X1 wall
    t = SnapToZero((m_C1[0] - pos[0]) / dir[0]);
    if (t > 0)
    {
        Y = pos[1] + t * dir[1];
        Z = pos[2] + t * dir[2];
        if ((Y >= m_C0[1]) && (Y <= m_C1[1]) &&
            (Z >= m_C0[2]) && (Z <= m_C1[2]) &&
			(bidirectional || t>=0))
        {
            if ((m_Side==-1) || (t<tMin))
            {
                tMin = t;
                m_Side = 1;
            }
        }
    }

    // Test the Y0 wall
    t = SnapToZero((m_C0[1] - pos[1]) / dir[1]);
    if (t > 0)
    {
        X = pos[0] + t * dir[0];
        Z = pos[2] + t * dir[2];
        if ((X >= m_C0[0]) && (X <= m_C1[0]) &&
            (Z >= m_C0[2]) && (Z <= m_C1[2]) &&
			(bidirectional || t>=0))
        {
            if ((m_Side==-1) || (t<tMin))
            {
                tMin = t;
                m_Side = 2;
            }
        }
    }

    // Test the Y1 walla
    t = SnapToZero((m_C1[1] - pos[1]) / dir[1]);
    if (t > 0)
    {
        X = pos[0] + t * dir[0];
        Z = pos[2] + t * dir[2];
        if ((X >= m_C0[0]) && (X <= m_C1[0]) &&
            (Z >= m_C0[2]) && (Z <= m_C1[2]) &&
			(bidirectional || t>=0))
        {
            if ((m_Side==-1) || (t<tMin))
            {
                tMin = t;
                m_Side = 3;
            }
        }
    }

    // Test the Z0 wall
    t = SnapToZero((m_C0[2] - pos[2]) / dir[2]);
    if (t > 0)
    {
        X = pos[0] + t * dir[0];
        Y = pos[1] + t * dir[1];
        if ((X >= m_C0[0]) && (X <= m_C1[0]) &&
            (Y >= m_C0[1]) && (Y <= m_C1[1]) &&
			(bidirectional || t>=0))
        {
            if ((m_Side==-1) || (t<tMin))
            {
                tMin = t;
                m_Side = 4;
            }
        }
    }

    // Test the Z1 wall
    t = SnapToZero((m_C1[2] - pos[2]) / dir[2]);
    if (t > 0)
    {
        X = pos[0] + t * dir[0];
        Y = pos[1] + t * dir[1];
        if ((X >= m_C0[0]) && (X <= m_C1[0]) &&
            (Y >= m_C0[1]) && (Y <= m_C1[1]) &&
			(bidirectional || t>=0))
        {
            if ((m_Side==-1) || (t<tMin))
            {
                tMin = t;
                m_Side = 5;
            }
        }
    }
	return tMin; 
}

/*---------------------------------------------------------------------------*/
bool DatGrid::copy_vol(byte* data, vu1112113 &r)
{
  if (!data) return false;
  maxX = r.m_Dim1Size;
  maxY = r.m_Dim2Size;
  maxZ = r.m_Dim3Size;
  //f.eatwhite();
  init(maxX,maxY,maxZ);
  int c;
  for(c=0;c<size;c++)
    {
      vol[c].data = data[c];
    }
  
  return true;
}

/*---------------------------------------------------------------------------*/
void DatGrid::shade(vu1112113 &r)
{
  int c;
  for(c=0;c<size;c++)
    vol[c].shade(r);
}

/*---------------------------------------------------------------------------*/
void DatGrid::calculate_gradients()
{
    int i,j,k;
    int offset=0;
    for(k=0;k<maxZ;k++)
      for(j=0;j<maxY;j++)
	for(i=0;i<maxX;i++)
	  {
	    DatPnt *cc = vol + offset;
	    float len = 0, nc;
	    nc =
		cc->norm[0]= (i          ? (int)vol[offset-1].data:0) -
		((i<maxX-1) ? (int)vol[offset+1].data:0);
	    len = nc*nc;
	    nc =
		cc->norm[1]= (j          ? (int)vol[offset-maxX].data:0)
		-((j<maxY-1) ? (int)vol[offset+maxX].data:0);
	    len += nc*nc;
	    nc = 
		cc->norm[2]= (k          ? (int)vol[offset-layXY].data:0)
		-((k<maxZ-1) ? (int)vol[offset+layXY].data:0);
	    len += nc*nc;
	    
	    if(len>0.0) {
		len = sqrt(len);
		float flen = 255.0f*len;
		if(flen > 255) cc->len = 255;
		else cc->len = byte(flen);
		cc->norm[0] /= len;
		cc->norm[1] /= len;
		cc->norm[2] /= len;
	    } else cc->len = 0;
	    
	    offset++;
	  }
}
