/*
### Written by Torsten Moeller
### sometime in March 1998
### let me know, if you find any errors (moeller@cis.ohio-state.edu)
*/
#include "tfilters.h"

#define OVER_3 0.33333333
#define OVER_6 0.16666666
#define OVER_12 0.0833333333
#define OVER_2_3 0.6666666666

namespace FVR_NS
{

static t_data  wm3g, wm3f, wm3e, wm3d, wm3c, wm3b, wm3a;
static t_data  wm2h, wm2g, wm2f, wm2e, wm2d, wm2c, wm2b, wm2a;
static t_data  wm1h, wm1g, wm1f, wm1e, wm1d, wm1c, wm1b, wm1a;
static t_data  wm0h, wm0g, wm0f, wm0e, wm0d, wm0c, wm0b, wm0a;
static t_data  wp1h, wp1g, wp1f, wp1e, wp1d, wp1c, wp1b, wp1a;
static t_data  wp2g, wp2f, wp2e, wp2d, wp2c, wp2b, wp2a;


int d0_c0_1ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = t;
  coeff[1] = 1-t;

  coeff[2] = 1;
  coeff[3] = -1;

  return 2;
}

int d0_c0_2ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = t;
  coeff[1] = 1-t;

  coeff[2] = 1;
  coeff[3] = -1;

  return 2;
}

int d0_c0_3ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = ( t -1)*t/4;
  coeff[1] = (-t +5)*t/4;
  coeff[2] = (-t -3)*t/4 +1;
  coeff[3] = ( t -1)*t/4;

  coeff[4] =  t/2.0 - 1/4.0f;
  coeff[5] = -t/2.0 + 5/4.0f;
  coeff[6] = -t/2.0 - 3/4.0f;
  coeff[7] =  t/2.0 - 1/4.0f;
  
  return 4;
}

int d0_c0_4ef(t_data a, t_data t, t_data *coeff) {

  wm2d =  OVER_6; wm2c =    0; wm2b = -OVER_6; wm2a = 0;
  wm1d =    -0.5; wm1c =  0.5; wm1b =       1; wm1a = 0;
  wm0d =     0.5; wm0c = -  1; wm0b =    -0.5; wm0a = 1;
  wp1d = -OVER_6; wp1c =  0.5; wp1b = -OVER_3; wp1a = 0;

  coeff[0] = ((wm2d*t +wm2c)*t +wm2b)*t;
  coeff[1] = ((wm1d*t +wm1c)*t +wm1b)*t;
  coeff[2] = ((wm0d*t +wm0c)*t +wm0b)*t +1;
  coeff[3] = ((wp1d*t +wp1c)*t +wp1b)*t;

  coeff[4] = (3*wm2d*t + 2 * wm2c)*t + wm2b;
  coeff[5] = (3*wm1d*t + 2 * wm1c)*t + wm1b;
  coeff[6] = (3*wm0d*t + 2 * wm0c)*t + wm0b;
  coeff[7] = (3*wp1d*t + 2 * wp1c)*t + wp1b;

  return 4;
}

int d0_c1_1ef(t_data a, t_data t, t_data *coeff) {

  wm1d = -2; wm1c =  3;
  wm0d =  2; wm0c = -3;

  coeff[0] = (wm1d*t +wm1c)*t*t;
  coeff[1] = (wm0d*t +wm0c)*t*t +1;

  coeff[2] = (3*wm1d*t + 2*wm1c)*t;
  coeff[3] = (3*wm0d*t + 2*wm0c)*t;

  return 2;
}

int d0_c1_2ef(t_data a, t_data t, t_data *coeff) {

  wm1a = 0.25;
  wm0a = 0.5;
  wp1a = 0.25;

  coeff[0] = ( t   )*t/4;
  coeff[1] = (-t +2)*t/4 +wm1a;
  coeff[2] = (-t   )*t/4 +wm0a;
  coeff[3] = ( t -2)*t/4 +wp1a;

  coeff[4] = t/2.0;
  coeff[5] = -t/2.0 + 1/2.0;
  coeff[6] = -t/2.0;
  coeff[7] = t/2.0 - 1/2.0;

  return 4;
}

int d0_c1_3ef(t_data a, t_data t, t_data *coeff) {

  wm2d =  0.5; wm2c = -0.5; wm2b =    0; wm2a = 0;
  wm1d = -1.5; wm1c =    2; wm1b =  0.5; wm1a = 0;
  wm0d =  1.5; wm0c = -2.5; wm0b =    0; wm0a = 1;
  wp1d = -0.5; wp1c =    1; wp1b = -0.5; wp1a = 0;

  coeff[0] = ((wm2d*t +wm2c)*t +wm2b)*t;
  coeff[1] = ((wm1d*t +wm1c)*t +wm1b)*t;
  coeff[2] = ((wm0d*t +wm0c)*t +wm0b)*t +1;
  coeff[3] = ((wp1d*t +wp1c)*t +wp1b)*t;

  coeff[4] = (3*wm2d*t + 2 * wm2c)*t + wm2b;
  coeff[5] = (3*wm1d*t + 2 * wm1c)*t + wm1b;
  coeff[6] = (3*wm0d*t + 2 * wm0c)*t + wm0b;
  coeff[7] = (3*wp1d*t + 2 * wp1c)*t + wp1b;


  return 4;
}

int d0_c1_4ef(t_data a, t_data t, t_data *coeff) {

  wm3d = -(   a       ); wm3c =  (1.5*a- 1./24); wm3b =          0; wm3a =             0;
  wm2d =  ( 5*a+OVER_6); wm2c = -(7.5*a- 1./8 ); wm2b = -(OVER_12); wm2a =  (0.5*a-1./24);
  wm1d = -(10*a+   0.5); wm1c =  ( 15*a+ 5./12); wm1b =  (OVER_2_3); wm1a = -(  2*a-OVER_6 );
  wm0d =  (10*a+   0.5); wm0c = -( 15*a+13./12); wm0b =          0; wm0a =  (  3*a+0.75 );
  wp1d = -( 5*a+OVER_6); wp1c =  (7.5*a+ 5./8 ); wp1b = -(OVER_2_3); wp1a = -(  2*a-OVER_6 );
  wp2d =  (   a       ); wp2c = -(1.5*a+ 1./24); wp2b =  (OVER_12); wp2a =  (0.5*a-1./24);

  coeff[0] = ((wm3d*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((wm2d*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((wm1d*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((wm0d*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((wp1d*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((wp2d*t +wp2c)*t +wp2b)*t +wp2a;

  coeff[6] = (3*wm3d*t + 2 * wm3c)*t + wm3b;
  coeff[7] = (3*wm2d*t + 2 * wm2c)*t + wm2b;
  coeff[8] = (3*wm1d*t + 2 * wm1c)*t + wm1b;
  coeff[9] = (3*wm0d*t + 2 * wm0c)*t + wm0b;
  coeff[10] = (3*wp1d*t + 2 * wp1c)*t + wp1b;
  coeff[11] = (3*wp2d*t + 2 * wp2c)*t + wp2b;

  return 6;
}

int d0_c2_1ef(t_data a, t_data t, t_data *coeff) {

  wm1f =  6; wm1e = -15; wm1d =  10; wm1c =  0; wm1b =  0; wm1a = 0;
  wm0f = -6; wm0e =  15; wm0d = -10; wm0c =  0; wm0b =  0; wm0a = 1;

  coeff[0] = ((wm1f*t +wm1e)*t +wm1d)*t*t*t;
  coeff[1] = ((wm0f*t +wm0e)*t +wm0d)*t*t*t +1;

  return 2;
}

int d0_c2_2ef(t_data a, t_data t, t_data *coeff) {

  wm2d =  OVER_6; wm2c =    0; wm2b =    0; wm2a =   0;
  wm1d =    -0.5; wm1c =  0.5; wm1b =  0.5; wm1a = OVER_6;
  wm0d =     0.5; wm0c = -  1; wm0b =    0; wm0a = OVER_2_3;
  wp1d = -OVER_6; wp1c =  0.5; wp1b = -0.5; wp1a = OVER_6;

  coeff[0] = ((wm2d*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[1] = ((wm1d*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[2] = ((wm0d*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[3] = ((wp1d*t +wp1c)*t +wp1b)*t +wp1a;

  return 4;
}

int d0_c2_3ef(t_data a, t_data t, t_data *coeff) {

  wm2f = -1; wm2e =   2.5; wm2d = -1.5; wm2c =    0; wm2b =    0; wm2a = 0;
  wm1f =  3; wm1e = - 7.5; wm1d =  4.5; wm1c =  0.5; wm1b =  0.5; wm1a = 0;
  wm0f = -3; wm0e =   7.5; wm0d = -4.5; wm0c = -  1; wm0b =    0; wm0a = 1;
  wp1f =  1; wp1e = - 2.5; wp1d =  1.5; wp1c =  0.5; wp1b = -0.5; wp1a = 0;

  coeff[0] = ((((wm2f*t +wm2e)*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[1] = ((((wm1f*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[2] = ((((wm0f*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[3] = ((((wp1f*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;

  coeff[4] = (((5.0 * wm2f*t + 4.0*wm2e)*t + 3.0*wm2d)*t + 2.0 * wm2c)*t + wm2b;
  coeff[5] = (((5.0 * wm1f*t + 4.0*wm1e)*t + 3.0*wm1d)*t + 2.0 * wm1c)*t + wm1b;
  coeff[6] = (((5.0 * wm0f*t + 4.0*wm0e)*t + 3.0*wm0d)*t + 2.0 * wm0c)*t + wm0b;
  coeff[7] = (((5.0 * wp1f*t + 4.0*wp1e)*t + 3.0*wp1d)*t + 2.0 * wp1c)*t + wp1b;

  return 4;
}

int d0_c2_4ef(t_data a, t_data t, t_data *coeff) {

  wm3d = - 1./36; wm3c =        0; wm3b =         0; wm3a =     0;
  wm2d =  11./36; wm2c = -OVER_12; wm2b =  -OVER_12; wm2a = -1./36;
  wm1d = - 7./9 ; wm1c =    5./6 ; wm1b =  OVER_2_3; wm1a =  1./9 ;
  wm0d =   7./9 ; wm0c =    -1.5 ; wm0b =         0; wm0a =  5./6 ;
  wp1d = -11./36; wp1c =    5./6 ; wp1b = -OVER_2_3; wp1a =  1./9 ;
  wp2d =   1./36; wp2c = -OVER_12; wp2b =   OVER_12; wp2a = -1./36;

  coeff[0] = ((wm3d*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((wm2d*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((wm1d*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((wm0d*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((wp1d*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((wp2d*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d0_c3_1ef(t_data a, t_data t, t_data *coeff) {

  wm1h = -20; wm1g =  70; wm1f = -84; wm1e =  35; wm1d =   0; wm1c =  0; wm1b =  0; wm1a = 0;
  wm0h =  20; wm0g = -70; wm0f =  84; wm0e = -35; wm0d =   0; wm0c =  0; wm0b =  0; wm0a = 1;

  coeff[0] = (((wm1h*t +wm1g)*t +wm1f)*t +wm1e)*t*t*t*t;
  coeff[1] = (((wm0h*t +wm0g)*t +wm0f)*t +wm0e)*t*t*t*t +1;

  return 2;
}

int d0_c3_2ef(t_data a, t_data t, t_data *coeff) {

  wm2f = -0.10; wm2e =  0.25; wm2d = 0; wm2c =    0; wm2b =    0; wm2a =    0;
  wm1f =  0.30; wm1e = -0.75; wm1d = 0; wm1c =  0.5; wm1b =  0.5; wm1a = 0.15;
  wm0f = -0.30; wm0e =  0.75; wm0d = 0; wm0c = -  1; wm0b =    0; wm0a = 0.70;
  wp1f =  0.10; wp1e = -0.25; wp1d = 0; wp1c =  0.5; wp1b = -0.5; wp1a = 0.15;

  coeff[0] =    (wm2f*t +wm2e)*t*t*t*t;
  coeff[1] = ((((wm1f*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[2] = ((((wm0f*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[3] = ((((wp1f*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;

  return 4;
}

int d0_c3_3ef(t_data a, t_data t, t_data *coeff) {

  wm2h =  3; wm2g = -10.5; wm2f =  12.5; wm2e = - 5; wm2d = 0; wm2c =    0; wm2b =    0; wm2a = 0;
  wm1h = -9; wm1g =  31.5; wm1f = -37.5; wm1e =  15; wm1d = 0; wm1c =  0.5; wm1b =  0.5; wm1a = 0;
  wm0h =  9; wm0g = -31.5; wm0f =  37.5; wm0e = -15; wm0d = 0; wm0c = -  1; wm0b =    0; wm0a = 1;
  wp1h = -3; wp1g =  10.5; wp1f = -12.5; wp1e =   5; wp1d = 0; wp1c =  0.5; wp1b = -0.5; wp1a = 0;

  coeff[0] = ((((((wm2h*t +wm2g)*t +wm2f)*t +wm2e)*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[1] = ((((((wm1h*t +wm1g)*t +wm1f)*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[2] = ((((((wm0h*t +wm0g)*t +wm0f)*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[3] = ((((((wp1h*t +wp1g)*t +wp1f)*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;

  return 4;
}

int d0_c3_4ef(t_data a, t_data t, t_data *coeff) {

  wm3f =   1./30; wm3e = - 1./16; wm3d =        0; wm3c =        0; wm3b =         0; wm3a = 0;
  wm2f = -OVER_6; wm2e =  17./48; wm2d =  OVER_12; wm2c =   -1./24; wm2b =  -OVER_12; wm2a = - 7./240;
  wm1f =  OVER_3; wm1e = -19./24; wm1d = -OVER_6 ; wm1c = OVER_2_3; wm1b =  OVER_2_3; wm1a =   7./60;
  wm0f = -OVER_3; wm0e =   7./8 ; wm0d =        0; wm0c =    -1.25; wm0b =         0; wm0a =  33./40;
  wp1f =  OVER_6; wp1e = -23./48; wp1d =  OVER_6 ; wp1c = OVER_2_3; wp1b = -OVER_2_3; wp1a =   7./60;
  wp2f =  -1./30; wp2e =   5./48; wp2d = -OVER_12; wp2c =   -1./24; wp2b =   OVER_12; wp2a = - 7./240;

  coeff[0] = ((((wm3f*t +wm3e)*t +wm3d)*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((((wm2f*t +wm2e)*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((((wm1f*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((((wm0f*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((((wp1f*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((((wp2f*t +wp2e)*t +wp2d)*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d0_cn_1ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = 0.5;
  coeff[1] = 0.5;

  return 2;
}

int d0_cn_2ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = t;
  coeff[1] = 1-t;

  return 2;
}

int d0_cn_3ef(t_data a, t_data t, t_data *coeff) {

  wm2c =  0.25; wm2b =  (2*a-0.25); wm2a = -(  a  );
  wm1c = -0.25; wm1b = -(6*a-1.25); wm1a =  (3*a  );
  wm0c = -0.25; wm0b =  (6*a-0.75); wm0a = -(3*a-1);
  wp1c =  0.25; wp1b = -(2*a+0.25); wp1a =  (  a  );

  coeff[0] = (wm2c*t +wm2b)*t + wm2a;
  coeff[1] = (wm1c*t +wm1b)*t + wm1a;
  coeff[2] = (wm0c*t +wm0b)*t + wm0a;
  coeff[3] = (wp1c*t +wp1b)*t + wp1a;

  return 4;
}

int d0_cn_4ef(t_data a, t_data t, t_data *coeff) {

  wm2d =  OVER_6; wm2c =    0; wm2b = -OVER_6; wm2a = 0;
  wm1d =    -0.5; wm1c =  0.5; wm1b =       1; wm1a = 0;
  wm0d =     0.5; wm0c = -1  ; wm0b =    -0.5; wm0a = 1;
  wp1d = -OVER_6; wp1c =  0.5; wp1b = -OVER_3; wp1a = 0;

  coeff[0] = ((wm2d*t +wm2c)*t +wm2b)*t + wm2a;
  coeff[1] = ((wm1d*t +wm1c)*t +wm1b)*t + wm1a;
  coeff[2] = ((wm0d*t +wm0c)*t +wm0b)*t + wm0a;
  coeff[3] = ((wp1d*t +wp1c)*t +wp1b)*t + wp1a;

  return 4;
}

int d1_c0_1ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = t/2;
  coeff[1] = (1-t)/2;
  coeff[2] = -t/2;
  coeff[3] = (t-1)/2;

  return 4;
}

int d1_c0_2ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] = t/2;
  coeff[1] = (1-t)/2;
  coeff[2] = -t/2;
  coeff[3] = (t-1)/2;

  return 4;
}

int d1_c0_3ef(t_data a, t_data t, t_data *coeff) {

  wm3c =  (   a    ); wm3b = -(   a+OVER_12); wm3a = 0;
  wm2c = -( 5*a-0.5); wm2b =  ( 5*a+   0.25); wm2a = -OVER_12;
  wm1c =  (10*a-1.5); wm1b = -(10*a-   5./6); wm1a =  OVER_2_3;
  wm0c = -(10*a-1.5); wm0b =  (10*a-  13./6); wm0a = 0;
  wp1c =  ( 5*a-0.5); wp1b = -( 5*a-   1.25); wp1a = -OVER_2_3;
  wp2c = -(   a    ); wp2b =  (   a-OVER_12); wp2a =  OVER_12;

  coeff[0] = (wm3c*t +wm3b)*t +wm3a;
  coeff[1] = (wm2c*t +wm2b)*t +wm2a;
  coeff[2] = (wm1c*t +wm1b)*t +wm1a;
  coeff[3] = (wm0c*t +wm0b)*t +wm0a;
  coeff[4] = (wp1c*t +wp1b)*t +wp1a;
  coeff[5] = (wp2c*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c0_4ef(t_data a, t_data t, t_data *coeff) {

  wm3d = OVER_12; wm3c =  (   a     ); wm3b = -(   a+ OVER_6); wm3a =       0;
  wm2d =   -0.25; wm2c = -( 5*a-0.25); wm2b =  ( 5*a+   0.75); wm2a = -OVER_12;
  wm1d =  OVER_6; wm1c =  (10*a- 0.5); wm1b = -(10*a+ OVER_3); wm1a =  OVER_2_3;
  wm0d =  OVER_6; wm0c = -(10*a     ); wm0b =  (10*a-   5./6); wm0a =       0;
  wp1d =   -0.25; wp1c =  ( 5*a+ 0.5); wp1b = -( 5*a-    0.5); wp1a = -OVER_2_3;
  wp2d = OVER_12; wp2c = -(   a+0.25); wp2b =  (   a+OVER_12); wp2a =  OVER_12;

  coeff[0] = ((wm3d*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((wm2d*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((wm1d*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((wm0d*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((wp1d*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((wp2d*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c1_1ef(t_data a, t_data t, t_data *coeff) {

  wm2c =  0.5; wm2b =  0; wm2a =    0;
  wm1c = -1.5; wm1b =  1; wm1a =  0.5;
  wm0c =  1.5; wm0b = -2; wm0a =    0;
  wp1c = -0.5; wp1b =  1; wp1a = -0.5;

  coeff[0] = (wm2c*t +wm2b)*t +wm2a;
  coeff[1] = (wm1c*t +wm1b)*t +wm1a;
  coeff[2] = (wm0c*t +wm0b)*t +wm0a;
  coeff[3] = (wp1c*t +wp1b)*t +wp1a;

  return 4;
}

int d1_c1_2ef(t_data a, t_data t, t_data *coeff) {

  wm2c =  0.5; wm2b =  0; wm2a =    0;
  wm1c = -1.5; wm1b =  1; wm1a =  0.5;
  wm0c =  1.5; wm0b = -2; wm0a =    0;
  wp1c = -0.5; wp1b =  1; wp1a = -0.5;

  coeff[0] = (wm2c*t +wm2b)*t +wm2a;
  coeff[1] = (wm1c*t +wm1b)*t +wm1a;
  coeff[2] = (wm0c*t +wm0b)*t +wm0a;
  coeff[3] = (wp1c*t +wp1b)*t +wp1a;

  return 4;
}

int d1_c1_3ef(t_data a, t_data t, t_data *coeff) {

  wm3c = -OVER_12; wm3b =       0; wm3a =  0;
  wm2c =   11./12; wm2b = -OVER_6; wm2a = -OVER_12;
  wm1c =    -7./3; wm1b =    5./3; wm1a =  OVER_2_3;
  wm0c =     7./3; wm0b =      -3; wm0a =  0;
  wp1c =  -11./12; wp1b =    5./3; wp1a = -OVER_2_3;
  wp2c =  OVER_12; wp2b = -OVER_6; wp2a =  OVER_12;

  coeff[0] = (wm3c*t +wm3b)*t +wm3a;
  coeff[1] = (wm2c*t +wm2b)*t +wm2a;
  coeff[2] = (wm1c*t +wm1b)*t +wm1a;
  coeff[3] = (wm0c*t +wm0b)*t +wm0a;
  coeff[4] = (wp1c*t +wp1b)*t +wp1a;
  coeff[5] = (wp2c*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c1_4ef(t_data a, t_data t, t_data *coeff) {

  wm3d =  OVER_12; wm3c =  -OVER_6; wm3b =        0; wm3a =  0;
  wm2d =    -0.25; wm2c =   13./12; wm2b = -OVER_12; wm2a = -OVER_12;
  wm1d =   OVER_6; wm1c =   -13./6; wm1b =     4./3; wm1a =  OVER_2_3 ;
  wm0d =   OVER_6; wm0c =     5./3; wm0b =     -2.5; wm0a =  0;
  wp1d =    -0.25; wp1c =  -OVER_3; wp1b =     4./3; wp1a = -OVER_2_3;
  wp2d =  OVER_12; wp2c = -OVER_12; wp2b = -OVER_12; wp2a =  OVER_12;

  coeff[0] = ((wm3d*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((wm2d*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((wm1d*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((wm0d*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((wp1d*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((wp2d*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c2_1ef(t_data a, t_data t, t_data *coeff) {

  wm2e = -0.5; wm2d =  1; wm2c = 0; wm2b =  0; wm2a =    0;
  wm1e =  1.5; wm1d = -3; wm1c = 0; wm1b =  1; wm1a =  0.5;
  wm0e = -1.5; wm0d =  3; wm0c = 0; wm0b = -2; wm0a =    0;
  wp1e =  0.5; wp1d = -1; wp1c = 0; wp1b =  1; wp1a = -0.5;

  coeff[0] = ((wm2e*t +wm2d)*t*t +wm2b)*t +wm2a;
  coeff[1] = ((wm1e*t +wm1d)*t*t +wm1b)*t +wm1a;
  coeff[2] = ((wm0e*t +wm0d)*t*t +wm0b)*t +wm0a;
  coeff[3] = ((wp1e*t +wp1d)*t*t +wp1b)*t +wp1a;

  return 4;
}

int d1_c2_2ef(t_data a, t_data t, t_data *coeff) {

  wm2e = -0.5; wm2d =  1; wm2c = 0; wm2b =  0; wm2a =  0;
  wm1e =  1.5; wm1d = -3; wm1c = 0; wm1b =  1; wm1a =  0.5;
  wm0e = -1.5; wm0d =  3; wm0c = 0; wm0b = -2; wm0a =  0;
  wp1e =  0.5; wp1d = -1; wp1c = 0; wp1b =  1; wp1a = -0.5;

  coeff[0] = (((wm2e*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[1] = (((wm1e*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[2] = (((wm0e*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[3] = (((wp1e*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;

  return 4;
}

int d1_c2_3ef(t_data a, t_data t, t_data *coeff) {

  wm3e =  OVER_6; wm3d =   -0.25; wm3c =     0; wm3b =        0; wm3a =  0;
  wm2e =   -5./6; wm2d =  17./12; wm2c =  0.25; wm2b = -OVER_12; wm2a = -OVER_12;
  wm1e =    5./3; wm1d =  -19./6; wm1c =  -0.5; wm1b =     4./3; wm1a =  OVER_2_3;
  wm0e =   -5./3; wm0d =     3.5; wm0c =     0; wm0b =     -2.5; wm0a =  0;
  wp1e =    5./6; wp1d = -23./12; wp1c =   0.5; wp1b =     4./3; wp1a = -OVER_2_3;
  wp2e = -OVER_6; wp2d =   5./12; wp2c = -0.25; wp2b = -OVER_12; wp2a =  OVER_12;

  coeff[0] = (((wm3e*t +wm3d)*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = (((wm2e*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = (((wm1e*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = (((wm0e*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = (((wp1e*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = (((wp2e*t +wp2d)*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c2_4ef(t_data a, t_data t, t_data *coeff) {

  wm3e =  OVER_6; wm3d =   -0.25; wm3c =     0; wm3b =        0; wm3a =  0;
  wm2e =   -5./6; wm2d =  17./12; wm2c =  0.25; wm2b = -OVER_12; wm2a = -OVER_12;
  wm1e =    5./3; wm1d =  -19./6; wm1c =  -0.5; wm1b =     4./3; wm1a =  OVER_2_3;
  wm0e =   -5./3; wm0d =     3.5; wm0c =     0; wm0b =     -2.5; wm0a =  0;
  wp1e =    5./6; wp1d = -23./12; wp1c =   0.5; wp1b =     4./3; wp1a = -OVER_2_3;
  wp2e = -OVER_6; wp2d =   5./12; wp2c = -0.25; wp2b = -OVER_12; wp2a =  OVER_12;

  coeff[0] = (((wm3e*t +wm3d)*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = (((wm2e*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = (((wm1e*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = (((wm0e*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = (((wp1e*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = (((wp2e*t +wp2d)*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c3_1ef(t_data a, t_data t, t_data *coeff) {

  wm2f = -0.75; wm2e =  1.25; wm2d =    0; wm2c = 0; wm2b =     0; wm2a =  0;
  wm1f =  0.75; wm1e =     0; wm1d = -2.5; wm1c = 0; wm1b =  1.25; wm1a =  0.5;
  wm0f =  0.75; wm0e = -3.75; wm0d =    5; wm0c = 0; wm0b =  -2.5; wm0a =  0;
  wp1f = -0.75; wp1e =  2.5 ; wp1d = -2.5; wp1c = 0; wp1b =  1.25; wp1a = -0.5;

  coeff[0] = ((((wm2f*t +wm2e)*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[1] = ((((wm1f*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[2] = ((((wm0f*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[3] = ((((wp1f*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;

  return 4;
}

int d1_c3_2ef(t_data a, t_data t, t_data *coeff) {

  wm2g =  1; wm2f = -3; wm2e =  2.5; wm2b =  0; wm2a =  0;
  wm1g = -3; wm1f =  9; wm1e = -7.5; wm1b =  1; wm1a =  0.5;
  wm0g =  3; wm0f = -9; wm0e =  7.5; wm0b = -2; wm0a =  0;
  wp1g = -1; wp1f =  3; wp1e = -2.5; wp1b =  1; wp1a = -0.5;

  coeff[0] = (((wm2g*t +wm2f)*t +wm2e)*t*t*t +wm2b)*t +wm2a;
  coeff[1] = (((wm1g*t +wm1f)*t +wm1e)*t*t*t +wm1b)*t +wm1a;
  coeff[2] = (((wm0g*t +wm0f)*t +wm0e)*t*t*t +wm0b)*t +wm0a;
  coeff[3] = (((wp1g*t +wp1f)*t +wp1e)*t*t*t +wp1b)*t +wp1a;

  return 4;
}

int d1_c3_3ef(t_data a, t_data t, t_data *coeff) {

  wm3f =  3./16; wm3e =   -13./48; wm3d =       0; wm3c =     0; wm3b =       0; wm3a =  0;
  wm2f = -9./16; wm2e =     5./12; wm2d =  19./24; wm2c =  0.25; wm2b = - 7./48; wm2a = -OVER_12;
  wm1f =  3./8 ; wm1e =    25./24; wm1d = -19./6 ; wm1c =  -0.5; wm1b =  19./12; wm1a =  OVER_2_3;
  wm0f =  3./8 ; wm0e =   -35./12; wm0d =  19./4 ; wm0c =     0; wm0b = -23./8 ; wm0a =  0;
  wp1f = -9./16; wp1e =   115./48; wp1d = -19./6 ; wp1c =   0.5; wp1b =  19./12; wp1a = -OVER_2_3;
  wp2f =  3./16; wp2e = -OVER_2_3; wp2d =  19./24; wp2c = -0.25; wp2b = - 7./48; wp2a =  OVER_12;

  coeff[0] = ((((wm3f*t +wm3e)*t +wm3d)*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((((wm2f*t +wm2e)*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((((wm1f*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((((wm0f*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((((wp1f*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((((wp2f*t +wp2e)*t +wp2d)*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d1_c3_4ef(t_data a, t_data t, t_data *coeff) {

  wm3g = -0.25; wm3f =  0.75; wm3e = - 7./12; wm3d =         0; wm3c =     0; wm3b =        0; wm3a =  0;
  wm2g =  1.25; wm2f = -3.75; wm2e =  35./12; wm2d =    OVER_6; wm2c =  0.25; wm2b = -OVER_12; wm2a = -OVER_12;
  wm1g =  -2.5; wm1f =   7.5; wm1e = -35./6 ; wm1d = -OVER_2_3; wm1c =  -0.5; wm1b =     4./3; wm1a =  OVER_2_3;
  wm0g =   2.5; wm0f =  -7.5; wm0e =  35./6 ; wm0d =         1; wm0c =     0; wm0b =    -5./2; wm0a =  0;
  wp1g = -1.25; wp1f =  3.75; wp1e = -35./12; wp1d = -OVER_2_3; wp1c =   0.5; wp1b =     4./3; wp1a = -OVER_2_3;
  wp2g =  0.25; wp2f = -0.75; wp2e =   7./12; wp2d =    OVER_6; wp2c = -0.25; wp2b = -OVER_12; wp2a =  OVER_12;

  coeff[0] = (((((wm3g*t +wm3f)*t +wm3e)*t +wm3d)*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = (((((wm2g*t +wm2f)*t +wm2e)*t +wm2d)*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = (((((wm1g*t +wm1f)*t +wm1e)*t +wm1d)*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = (((((wm0g*t +wm0f)*t +wm0e)*t +wm0d)*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = (((((wp1g*t +wp1f)*t +wp1e)*t +wp1d)*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = (((((wp2g*t +wp2f)*t +wp2e)*t +wp2d)*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

int d1_cn_1ef(t_data a, t_data t, t_data *coeff) {

  coeff[0] =  0;
  coeff[1] =  1;
  coeff[2] = -1;
  coeff[3] =  0;

  return 4;
}

int d1_cn_2ef(t_data a, t_data t, t_data *coeff) {

  wm2b =  0.5; wm2a =  (  a    );
  wm1b = -0.5; wm1a = -(3*a-0.5);
  wm0b = -0.5; wm0a =  (3*a    );
  wp1b =  0.5; wp1a = -(  a+0.5);

  coeff[0] = wm2b*t +wm2a;
  coeff[1] = wm1b*t +wm1a;
  coeff[2] = wm0b*t +wm0a;
  coeff[3] = wp1b*t +wp1a;

  return 4;
}

int d1_cn_3ef(t_data a, t_data t, t_data *coeff) {

  wm2c =  0.5; wm2b =  0; wm2a = -OVER_6;
  wm1c = -1.5; wm1b =  1; wm1a =       1;
  wm0c =  1.5; wm0b = -2; wm0a =    -0.5;
  wp1c = -0.5; wp1b =  1; wp1a = -OVER_3;

  coeff[0] = (wm2c*t +wm2b)*t +wm2a;
  coeff[1] = (wm1c*t +wm1b)*t +wm1a;
  coeff[2] = (wm0c*t +wm0b)*t +wm0a;
  coeff[3] = (wp1c*t +wp1b)*t +wp1a;

  return 4;
}

int d1_cn_4ef(t_data a, t_data t, t_data *coeff) {

  wm3d =  OVER_12; wm3c =  (   a     ); wm3b = -(   a+ OVER_6); wm3a =  0;
  wm2d =    -0.25; wm2c = -( 5*a-0.25); wm2b =  ( 5*a+   0.75); wm2a = -OVER_12;
  wm1d =   OVER_6; wm1c =  (10*a- 0.5); wm1b = -(10*a+ OVER_3); wm1a =  OVER_2_3;
  wm0d =   OVER_6; wm0c = -(10*a     ); wm0b =  (10*a-   5./6); wm0a = 0;
  wp1d =    -0.25; wp1c =  ( 5*a+ 0.5); wp1b = -( 5*a-    0.5); wp1a = -OVER_2_3;
  wp2d =  OVER_12; wp2c = -(   a+0.25); wp2b =  (   a+OVER_12); wp2a =  OVER_12;

  coeff[0] = ((wm3d*t +wm3c)*t +wm3b)*t +wm3a;
  coeff[1] = ((wm2d*t +wm2c)*t +wm2b)*t +wm2a;
  coeff[2] = ((wm1d*t +wm1c)*t +wm1b)*t +wm1a;
  coeff[3] = ((wm0d*t +wm0c)*t +wm0b)*t +wm0a;
  coeff[4] = ((wp1d*t +wp1c)*t +wp1b)*t +wp1a;
  coeff[5] = ((wp2d*t +wp2c)*t +wp2b)*t +wp2a;

  return 6;
}

} // END_NS
