#ifndef _TORSTENSFILTERS_H_
#define _TORSTENSFILTERS_H_

#include "SimpleDefs.h"
#include "vuSimpleTypes.h"
#include "Filter.h"
#include "tfilters.h"

namespace FVR_NS {

// max extent of a filter for things to work
//#define MAX_TFILTER_EXTENT	10 
#define MAX_TFILTER_EXTENT	20 //the second half is for the gradients!

class TorstensFilters : public Filter
{
public:
    TorstensFilters();
    TorstensFilters(TorstensFilters& l);
    TorstensFilters(int (*filter)(t_data a, t_data t, t_data *coeff), t_data a = 0.0f);
    virtual ~TorstensFilters();

    void SetFilter(int (*filter)(t_data a, t_data t, t_data *coeff), t_data a = 0.0f);

    virtual dword getWidth(void);

    TorstensFilters& operator=(TorstensFilters& rhs);

protected:
	virtual void MakeWeights(void);

private:
    void MakeWeightCube(t_data* w, vuVector* v, t_data ti, t_data tj, t_data tk);

private:
    int (*m_Filter)(t_data a, t_data t, t_data *coeff);
    dword m_FilterWidth;
    t_data m_a;
};

} // NS_END

#endif

