#include "TorstensFilters.h"

namespace FVR_NS
{

TorstensFilters::TorstensFilters()
{
}

TorstensFilters::TorstensFilters(TorstensFilters& l)
{
}

TorstensFilters::TorstensFilters(int (*filter)(t_data a, t_data t, t_data *coeff), t_data a)
{
	SetFilter(filter, a);
}

TorstensFilters::~TorstensFilters()
{
}

TorstensFilters& TorstensFilters::operator=(TorstensFilters& rhs)
{
	return *this;
}

void TorstensFilters::SetFilter(int (*filter)(t_data a, t_data t, t_data *coeff), t_data a)
{
	t_data Coeff[MAX_TFILTER_EXTENT];
	m_Filter = filter;
	m_FilterWidth = (dword) m_Filter(a, 0, Coeff);
	m_FilterSize = m_FilterWidth * m_FilterWidth * m_FilterWidth;
	m_a = a;

	MakeWeights();
}

dword TorstensFilters::getWidth(void)
{
	return m_FilterWidth;
}

void TorstensFilters::MakeWeights(void)
{
  t_data ti, tj, tk;
  t_data tstep;
  dword pos;
  
  m_Weights = new t_data[FILTER_TABLE_SIZE *
		       FILTER_TABLE_SIZE *
		       FILTER_TABLE_SIZE * m_FilterSize];

  m_grads = new vuVector[FILTER_TABLE_SIZE *
		       FILTER_TABLE_SIZE *
		       FILTER_TABLE_SIZE * m_FilterSize];
  
  tstep = 1.0f / (t_data)FILTER_TABLE_SIZE;
  
  pos = 0;
  tk = 0;
  for(dword k = 0; k < FILTER_TABLE_SIZE; ++k) {
    tj = 0;
    for(dword j = 0; j < FILTER_TABLE_SIZE; ++j) {
      ti = 0;
      for(dword i = 0;i < FILTER_TABLE_SIZE; ++i) {
	MakeWeightCube(&m_Weights[pos], &m_grads[pos], ti, tj, tk);
	
	pos += m_FilterSize;
	ti += tstep;
      }
      tj += tstep;
    }
    tk += tstep;
  }
}

void TorstensFilters::MakeWeightCube(t_data* w, vuVector* v, t_data ti, t_data tj, t_data tk)
{
  //double the filter extent for the gradient of the filter reside in second half of wi,wj,wk
  t_data wi[MAX_TFILTER_EXTENT], wj[MAX_TFILTER_EXTENT], wk[MAX_TFILTER_EXTENT];

  m_Filter(m_a, ti, wi);
  m_Filter(m_a, tj, wj);
  m_Filter(m_a, tk, wk);
  
  dword pos = 0;
  for(dword k = 0; k < m_FilterWidth; ++k)
    for(dword j = 0; j < m_FilterWidth; ++j)
      for(dword i = 0; i < m_FilterWidth; ++i)
	{
	  w[pos] = wi[i] * wj[j] * wk[k];
	  //	  v[pos++] = vuVector(wi[m_FilterWidth + i], wj[m_FilterWidth + j], wk[m_FilterWidth + k]);
	  vuVector myv(0,0,0);
	  myv[0] = wj[j] * wk[k] * wi[m_FilterWidth + i];
	  myv[1] = wi[i] * wk[k] * wj[m_FilterWidth + j];
	  myv[2] = wi[i] * wj[j] * wk[m_FilterWidth + k];
	  v[pos++] = myv;//wk[m_FilterWidth + k]);
	}
}

} // NS_END
