#ifndef _FVR_IMAGE_IO_H_
#define _FVR_IMAGE_IO_H_
// set of functions to work on raw, pvp and fvr files
// need to add some checks to see if things worked and handle white space better

#include <fstream.h>
#include "SimpleDefs.h"
#include "vuSimpleTypes.h"
#include "vuVector.h"

namespace FVR_NS
{

#define MAGIC_NUM_LEN	128

// read XSize x YSize x ZSize integers with d_size bytes from fin to vol
// converts to t_datas and assumes vol is size X, Y, Z
void read_raw(ifstream& fin, t_data* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size);

// read XSize x YSize x ZSize integers with d_size bytes from data to vol
// converts to t_datas and assumes vol is size X, Y, Z
void read_raw(byte *data, float* vol, dword X, dword Y, dword Z, 
	      dword XSize, dword YSize, dword ZSize, dword d_size);

// same as above, but read data members in raw
void read_raw_r(ifstream& fin, byte* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size);

// same as abouve, but faster (using buffers)
void read_raw_fast(ifstream& fin, byte* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size);

// read pvp or fvr header; return 0 on fail, 1 if pvp, 2 if fvr
int read_head(ifstream& in, dword& XSize, dword& YSize, dword& ZSize, dword& b_size);

bool write_pvp_head(ofstream& fout, dword XSize, dword YSize, dword ZSize, dword b_size);

bool write_fvr_head(ofstream& fout, dword XSize, dword YSize, dword ZSize, dword b_size);

void spitData(float *data, dword len, const char* fileName);
void spitVec3d(vuVector* v, dword len, const char* fileName);

} // END_NS

#endif
