#include "Image_io.h"
#include <stdio.h>
#include <string.h>
#include <iostream.h>

namespace FVR_NS
{

// complex pad n spaces
static t_data* pad(t_data* v, dword n)
{
	for (dword i = 0; i < n; ++i) {
		*(v++) = 0.0f;
		*(v++) = 0.0f;
	}
	return v;
}

// pad n spaces
static byte* pad_r(byte* v, dword n)
{
	for (dword i = 0; i < n; ++i) {
		*(v++) = 0;
	}
	return v;
}

static dword readNumber(ifstream& fin)
{
	dword n = 0;
	int c;

	c = fin.get();
	while((c!=' ') && (c!=10) && (c!=13))
	{
		n = n*10 + ((dword)c-'0');
		c = fin.get();
	}
	return n;
}

static void writeNumber(ofstream& fout, dword n)
{
	char number[16];

	sprintf(number, "%ld", n);
	fout.write(number, strlen(number));
	fout.put(' ');
}

void read_raw(ifstream& fin, t_data* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size)
{
	if (!fin.is_open()) return;

	t_data* v_ptr = vol;

	dword lowX = (X - XSize) / 2;
	dword lowY = (Y - YSize) / 2;
	dword lowZ = (Z - ZSize) / 2;

	dword hiX = X - lowX - XSize;
	dword hiY = Y - lowY - YSize;
	dword hiZ = Z - lowZ - ZSize;

	v_ptr = pad(v_ptr, lowZ * X * Y);
	for (dword k = 0; k < ZSize; ++k) {

		v_ptr = pad(v_ptr, lowY * X);
		for (dword j = 0; j < YSize; ++j) {

			v_ptr = pad(v_ptr, lowX);
			for (dword i = 0; i < XSize; ++i) {

				// convert d_size bytes to floating point
				t_data tmp = 0.0f;
				for (dword d = 0; d < d_size; ++d) {
					tmp *= 256.0f;
					int c = fin.get();
					if (c < 0) cerr << "huh??\n";
					tmp += (t_data) c;
				}
				*(v_ptr++) = tmp;
				*(v_ptr++) = 0.0f;

			}
			v_ptr = pad(v_ptr, hiX);

		}
		v_ptr = pad(v_ptr, hiY * X);

	}
	v_ptr = pad(v_ptr, hiZ * X * Y);
}

void read_raw(byte *data, float* vol, dword X, dword Y, dword Z, 
	      dword XSize, dword YSize, dword ZSize, dword d_size)
{
  if (!data) return;

  float* v_ptr = vol;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  v_ptr = pad(v_ptr, lowZ * X * Y);
  for (dword k = 0; k < ZSize; ++k) {

    v_ptr = pad(v_ptr, lowY * X);
    for (dword j = 0; j < YSize; ++j) {

      v_ptr = pad(v_ptr, lowX);
      for (dword i = 0; i < XSize; ++i) {

	// convert d_size bytes to floating point
	float tmp = 0.0f;
	for (dword d = 0; d < d_size; ++d) {
	  tmp *= 256.0f;
	  byte c = *(data++);
	  tmp += (float) c;
	}
	*(v_ptr++) = tmp;
	*(v_ptr++) = 0.0f;

      }
      v_ptr = pad(v_ptr, hiX);

    }
    v_ptr = pad(v_ptr, hiY * X);

  }
  v_ptr = pad(v_ptr, hiZ * X * Y);
}

void read_raw_r(ifstream& fin, byte* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size)
{
	if (!fin.is_open()) return;

	byte* v_ptr = vol;

	dword lowX = (X - XSize) / 2;
	dword lowY = (Y - YSize) / 2;
	dword lowZ = (Z - ZSize) / 2;

	dword hiX = X - lowX - XSize;
	dword hiY = Y - lowY - YSize;
	dword hiZ = Z - lowZ - ZSize;

	v_ptr = pad_r(v_ptr, lowZ * X * Y * d_size);
	for (dword k = 0; k < ZSize; ++k) {

		v_ptr = pad_r(v_ptr, lowY * X * d_size);
		for (dword j = 0; j < YSize; ++j) {

			v_ptr = pad_r(v_ptr, lowX * d_size);
			for (dword i = 0; i < XSize; ++i) {

				for (dword d = 0; d < d_size; ++d) {
					int c = fin.get();
					if (c < 0) cerr << "huh??\n";
					*(v_ptr++) = (byte) c;
				}

			}
			v_ptr = pad_r(v_ptr, hiX * d_size);

		}
		v_ptr = pad_r(v_ptr, hiY * X * d_size);

	}
	v_ptr = pad_r(v_ptr, hiZ * X * Y * d_size);
}

void read_raw_fast(ifstream& fin, byte* vol, dword X, dword Y, dword Z, dword XSize, dword YSize, dword ZSize, dword d_size)
{
  if (!fin.is_open()) return;

  byte* v_ptr = vol;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  int  length;
  char *buffer;

  length = XSize*YSize*ZSize*d_size;
  buffer = new char[length];

  fin.read(buffer, length);
  
  dword idx = 0;

  v_ptr = pad_r(v_ptr, lowZ * X * Y * d_size);
  for (dword k = 0; k < ZSize; ++k) {

    v_ptr = pad_r(v_ptr, lowY * X * d_size);
    for (dword j = 0; j < YSize; ++j) {

      v_ptr = pad_r(v_ptr, lowX * d_size);
      for (dword i = 0; i < XSize; ++i) {

	for (dword d = 0; d < d_size; ++d) {
	  *(v_ptr++) = (byte)buffer[idx++];
	}

      }
      v_ptr = pad_r(v_ptr, hiX * d_size);

    }
    v_ptr = pad_r(v_ptr, hiY * X * d_size);

  }
  v_ptr = pad_r(v_ptr, hiZ * X * Y * d_size);

  delete buffer;
}

int read_head(ifstream& fin, dword& XSize, dword& YSize, dword& ZSize, dword& b_size)
{
	if (!fin.is_open()) return 0;

	char head[MAGIC_NUM_LEN];

	int i = 0;
	int c = fin.get();
	for (; (c!=' ') && (c!=10) && (c!=13); i++) {
		head[i] = c;
		c = fin.get();
	}
	head[i] = '\0';

	int ret = 0;
	if (strcmp(head, "PVP") == 0)
		ret = 1;
	else if (strcmp(head, "FVR") == 0)
		ret = 2;
	else
		return 0;

	XSize = readNumber(fin);
	YSize = readNumber(fin);
	ZSize = readNumber(fin);
	b_size = readNumber(fin);
	char ccc = fin.get();
	if(ccc != '\n')
	  cout <<"Badly formed header file: " << ccc << endl;
	return ret;
}

bool write_pvp_head(ofstream& fout, dword XSize, dword YSize, dword ZSize, dword b_size)
{
	if (!fout.is_open()) return false;
	fout.write("PVP\n", 4);
	writeNumber(fout, XSize);
	writeNumber(fout, YSize);
	writeNumber(fout, ZSize);
	writeNumber(fout, b_size);
	return true;
}

bool write_fvr_head(ofstream& fout, dword XSize, dword YSize, dword ZSize, dword b_size)
{
	if (!fout.is_open()) return false;
	fout.write("FVR\n", 4);
	writeNumber(fout, XSize);
	writeNumber(fout, YSize);
	writeNumber(fout, ZSize);
	writeNumber(fout, b_size);
	fout.write("\n", 1);
	
	return true;
}


void spitData(float *data, dword len, const char* fileName)
{
  FILE* outf = fopen(fileName, "wb+");
  dword itemsWrote = 0;
  while(true)
    {
      int itemsWritten = fwrite(&data[itemsWrote], sizeof(float), len, outf);
      if(itemsWritten <= 0)
	{
	  cout << "Error writing " << flush << endl;
	  return;
	}
      itemsWrote += itemsWritten;
      if(itemsWrote == len)
	break;
    }
  fflush(outf);
  fclose(outf);
}


void spitVec3d(vuVector* vec, dword len, const char* fileName)
{
  FILE* outf = fopen(fileName, "wb+");
  for(dword i = 0; i < len; i++)
    {
      float v[3];
      v[0] = vec[i][0];
      v[1] = vec[i][1];
      v[2] = vec[i][2];

      int ret = fwrite(&v[0], sizeof(float), 3, outf);
      if(ret <= 0)
	{
	  cout <<"Error writing the vector to file"<< endl << flush;
	}
    }
  
  fflush(outf);
  fclose(outf);
}

} // END_NS
