#ifndef _FVR_FILTER2_H_
#define _FVR_FILTER2_H_

#include "vuVector.h"
#include "vuSimpleTypes.h"

namespace FVR_NS {

#define FILTER_TABLE_SIZE  20
#define FILTER_TABLE_MAX   19

class Filter
{
 public:
  inline Filter();
  inline Filter(Filter& f);
  virtual ~Filter();
  
  inline t_data* getWeights(vuVector& t);
  inline vuVector* getGrad(vuVector& t);
  virtual dword getWidth(void) = 0;
  
  inline Filter& operator=(Filter& rhs);
  
 protected:
  t_data*  m_Weights;   // A table of weights
  vuVector* m_grads;     // a table of vector of gradients.
  dword m_FilterSize;
};

inline Filter::Filter() : m_Weights(0)
{
}

inline Filter::Filter(Filter& f)
{
}

inline Filter::~Filter()
{
  if (m_Weights)
    delete [] m_Weights;
  if(m_grads)
    delete [] m_grads;
}

inline Filter& Filter::operator=(Filter& rhs)
{
	return *this;
}

inline t_data* Filter::getWeights(vuVector& t)
{
	int i = (int)((t[0] * FILTER_TABLE_MAX) + 0.5);
	int j = (int)((t[1] * FILTER_TABLE_MAX) + 0.5);
	int k = (int)((t[2] * FILTER_TABLE_MAX) + 0.5);
	return &m_Weights[((k * FILTER_TABLE_SIZE + j) * FILTER_TABLE_SIZE + i) * m_FilterSize];
}

inline vuVector* Filter::getGrad(vuVector& t)
{
	int i = (int)((t[0] * FILTER_TABLE_MAX) + 0.5);
	int j = (int)((t[1] * FILTER_TABLE_MAX) + 0.5);
	int k = (int)((t[2] * FILTER_TABLE_MAX) + 0.5);
	return &m_grads[((k * FILTER_TABLE_SIZE + j) * FILTER_TABLE_SIZE + i) * m_FilterSize];
}

} // NS_END

#endif

