#ifndef _FVR_vu1112117_H_
#define _FVR_vu1112117_H_

#include <string>
#include <fstream.h>
#include "SimpleDefs.h"
#include <vuSimpleTypes.h>
#include "vuVector.h"
#include "Filter.h"

#include "../intensity.h"
#include "glos.h"

#include <GL/gl.h>
#include <GL/glu.h>

#include "vuImage.h"
#include "vuThread.h"
#include "vuColourRGBa.h"

//#define FVR_NO_SLICE_COPY

using namespace FVR_NS;

#define VOLUME_MAX_NUM 10

class vu1112117;
typedef vu1112117 vuVolumeRegularUnimodal3d1B1ValFVR;

class vu1112117 : public vu111211, public vuThread
{
public:
  void compareVolumes();
    // Default constructor, copy constructor,
    // and destructor.
    vu1112117();
    vu1112117(vu1112117& inst);
    ~vu1112117();


public:
    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();

    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    //!Initializes open gl for rendering the volume data.
    void initOpenGL(void);

    vuImage* getBuffer ();

    //!Sets the camera viewing position for the render method.
    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

    // Assignment operator for the volume class.
    vu1112117& operator=(const vu1112117& rhs);

    // Set the interpolation filter.
    void setFilter(Filter* filter);

    // Set the scale and bias for the slice extraction
    // stage of the algorithm.
    void setSliceScale(t_data scale);
    void setSliceBias(t_data bias);

    // Rotate the slice about its x, y, or z axis.
    // The rotations are local to the slice (it carries
    // its own coordinate axis system).
    void rotateSliceX(t_data alpha);
    void rotateSliceY(t_data alpha);
    void rotateSliceZ(t_data alpha);

    // Compute the slice for the current angle and
    // return the rgb's in a byte*.
    // Stop is middle section, pass is bandwidth
    void clearSlices(void);
    void computeSlice(void);
    void refineSlice(dword x_stop, dword y_stop, dword x_pass, dword y_pass);

    // Get the dimensions of the current slice (for
    // the current version, the same values are returned
    // for all angles.)
    dword getImageWidth(void) const;
    dword getImageHeight(void) const;

    dword getSliceWidth(void) const;
    dword getSliceHeight(void) const;

    // set oversampling -- 2 uses twice the number of samples
    void setOversampling(t_data s);
    float* getScale();
    float* getLightIntensity();
private:
    // Set the width of the wrap in the frequency
    // domain.  Should be half the filter size.
    void setWrap(dword wrap);

    // Fix the frequency volume so that it wraps its
    // values periodically to half of the filter width.
    void wrapVolume(t_data* &_volume);

    // Interpolate the slice, using the currently
    // selected filter.
    void interpolateSlice(t_data* &_volume, t_data* &_slice,
			  t_data &_shLight, t_data &_currDC);
    void interpolateSlice(t_data* &_volume, t_data* &_slice,
			  t_data &_shLight, t_data &_currDC,
			  dword x_stop, dword y_stop,
			  dword x_pass, dword y_pass);


	inline int vu1112117::vcoord(int x, int y, int z) const
	{
		return ((z * m_Dim2Size + y) * m_Dim1Size + x) * 2;
	}

	inline int vu1112117::scoord(int x, int y) const
	{
		return (y * m_SliceXSize + x) * 2;
	}

	void preprocess(void);
	void write_fvr(char* out);// const;
	bool read_fvr(t_data* &_volume, ifstream& fin,
		      dword XSize, dword YSize, dword ZSize, dword d_size);
	bool read_shfvr(char* in);
	bool doTempFilesExist(string fileName);
	void ensureTempDirectory();
 public:
	// Scale and bias the frequency slice into the rgb
	// slice.
	void scaleAndBias(t_data* _slice, const vuColourRGBa &color);
	
	// set light position in world coords
	void setLightPosition(const vuVector &_light);
	void setIsDepthCueing(bool flag);
	bool IsDepthCueing(void);

	void setIsDiffuseShading(bool flag);
	bool IsDiffuseShading();

	void setIsPostProcessing(bool flag);
	bool IsPostProcessing(void);

	void setAmbientColour(const vuColourRGBa _colour);
	vuColourRGBa getAmbientColour(void);

	void setDiffuseColour(const vuColourRGBa _colour);
	vuColourRGBa getDiffuseColour(void);

	void drawImageFromSlices(void);

private:
    // Variables for the volume.
    int m_volumeNumber;
    t_data* m_Yarray[VOLUME_MAX_NUM];    // arrays of spherical harmonics basis
    void deleteVolumes();
    t_data m_shLight[VOLUME_MAX_NUM];  // spherical harmonics light
    bool   m_depthCue;
    dword  m_Wrap;         // Width of the wrap on the volume
    vuVector m_currLight;  // holds the current light in the current coordinate system

    // colour
    vuColourRGBa m_AmbientColour;
    vuColourRGBa m_DiffuseColour;

    // Variables for the interpolation filter
    Filter* m_Filter;

    // Variables for the slice
    t_data* m__SliceArray[VOLUME_MAX_NUM]; //for parallel computing of slices
    t_data* m_Slice; // used by drawImageFormSlices()

    vuVector m_XStep;        // Xstep for sampling
    vuVector m_YStep;        // Ystep for sampling
    dword    m_SliceXSize;   // Slice x-size
    dword    m_SliceYSize;   // Slice y-size
    vuVector m_XAxis;        // Slice x-axis
    vuVector m_YAxis;        // Slice y-axis
    vuVector m_ZAxis;        // Slice z-axis
    vuVector m_Origin;       // Bottom left corner of slice

    // image vars
    vuImage m_Image;
    float m_Scale;          // Slice scale factor
    t_data m_Bias;          // Slice bias factor
    
    dword m_InnerXSize;
    dword m_InnerYSize;

    bool m_isPostProcessing;

    void updateShLight();

    void destroySlices(void);
    void ensureSlices(void);
    void accumulateSlices(t_data* _slice, int _from, int _to);
    void computeSlice(int num);
    void refineSlice(int num,
		     dword x_stop, dword y_stop, dword x_pass, dword y_pass);

    // threads
    vuMutex m_Mutex[VOLUME_MAX_NUM];

    void run(int whatsup, void* data);
    bool computeSlicesUsingThreads(void);
    bool refineSlicesUsingThreads(dword x_stop, dword y_stop,
				  dword x_pass, dword y_pass);

    void _clearSlices(void);
    void _ensureSliceDummy(void);

    int computeDimension(void);
    void buildVolume(t_data* _volume, byte* _data, dword dim,
		     dword XSize, dword YSize, dword ZSize);


    void _init(void);
};
#endif
