#include "Transform.h"
#include "Image_io.h"
#include <stdio.h>
#include <fftw.h>
#include <iostream.h>

namespace FVR_NS
{

#define WISDOM "fvr_fftw.wis"

static fftwnd_plan g_plan_2D;
static bool g_plan_exists = false;
static dword g_x3d;
static dword g_y3d;
static dword g_z3d;

void initTransforms(void)
{
	FILE* wisdom_file = fopen(WISDOM, "a+");
	if(!wisdom_file) {
	    cout<<"Could not load wisdom."<<endl;
	    return;
	}
	rewind(wisdom_file);
	fftw_import_wisdom_from_file(wisdom_file);
	fclose(wisdom_file);
}

void destroyTransforms(void)
{
	FILE* wisdom_file = fopen(WISDOM, "w");
	if(!wisdom_file) {
	    cout << "Could not save wisdom."<<endl;
	    return;
	}
	fftw_export_wisdom_to_file(wisdom_file);
	fclose(wisdom_file);
}

void initTransform2D(dword XSize, dword YSize)
{
  g_plan_2D = fftw2d_create_plan(YSize, XSize, FFTW_BACKWARD, FFTW_MEASURE | FFTW_IN_PLACE | FFTW_USE_WISDOM);
  g_plan_exists=true;
}

void transform2D(t_data* x)
{
  if(g_plan_exists)
    fftwnd_one(g_plan_2D, (fftw_complex*) x, 0);
  else cout << "no plan" << endl;
}

void destroyTransform2D(void)
{
    if(g_plan_exists) {
	fftwnd_destroy_plan(g_plan_2D);
	g_plan_exists = false;
    }
}

void initTransform3D(dword XSize, dword YSize, dword ZSize)
{
	g_x3d = XSize;
	g_y3d = YSize;
	g_z3d = ZSize;
}

void transform3D(t_data* x)
{
	fftwnd_plan p;
	p = fftw3d_create_plan(g_z3d, g_y3d, g_x3d, FFTW_FORWARD, FFTW_ESTIMATE | FFTW_IN_PLACE | FFTW_USE_WISDOM);
	
	fftwnd_one(p, (fftw_complex*) x, NULL);
	fftwnd_destroy_plan(p);
	dword size_i = g_z3d * g_y3d * g_x3d * 2;
	t_data size_f = (t_data) g_z3d * g_y3d * g_x3d;
	for (dword i = 0; i < size_i; ++i)
		x[i] /= size_f;
}

void destroyTransform3D(void)
{
	g_x3d = 0;
	g_y3d = 0;
	g_z3d = 0;
}

void shift3D(t_data* x, dword XSize, dword YSize, dword ZSize)
{
  dword xstep;
  dword ystep;
  dword i;
  dword j;
  dword k;
  dword index1;
  int start1 = 0;
  int val1   = -1;
  dword index2;
  int start2;
  int val2;
  
  xstep = XSize * 2;
  ystep = YSize * XSize * 2;
  
  index1 = 0;
  for(k = 0; k < ZSize; ++k)
    {
      index2 = index1;
      start2 = start1;
      val2   = val1;
      for(j = 0; j < YSize; ++j)
	{
	  for(i = start2; i < xstep; i += 4)
	    {
	      x[index2+i]   *= -1.0f;
	      x[index2+i+1] *= -1.0f;
	    }
	  val2 *= -1;
	  start2 += val2*2;
	  index2 += xstep;
	}
      val1 *= -1;
      start1 += val1*2;
      index1 += ystep;
    }
}

void shift2D(t_data* x, dword XSize, dword YSize)
{
  dword xstep;
  dword i;
  dword j;
  dword index;
  int start = 0;
  int val = -1;
  
  xstep = XSize * 2;
  
  index = 0;
  for (j = 0; j < YSize; ++j) {
    for (i = start; i < xstep; i += 4) {
      x[index+i]   *= -1.0f;
      x[index+i+1] *= -1.0f;
    }
    val *= -1;
    start += val * 2;
    index += xstep;
  }
}



void shift_copy2D(t_data* dest, t_data* src, dword XSize, dword YSize)
{
	dword i, j;
	dword xlast = XSize / 2;
	dword ylast = YSize / 2;

	t_data* src_ptr = src;
	t_data* dest_ptr = dest;

	for (j = 0; j < ylast; ++j) {
		for (i = 0; i < xlast; ++i) {
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
			*(dest_ptr++) = *(src_ptr++);
			*(dest_ptr++) = *(src_ptr++);
		}
		for (i = 0; i < xlast; ++i) {
			*(dest_ptr++) = *(src_ptr++);
			*(dest_ptr++) = *(src_ptr++);
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
			*(dest_ptr++) = *(src_ptr++) * -1.0f;
		}
	}
}

inline int vcoord(int x, int y, int z)
{
  return ((z * g_y3d + y) * g_x3d + x) * 2;
}

void doStuff(t_data* x, int xMax, int yMax, int zMax)
{
  fftwnd_plan myplan;
  myplan = fftw3d_create_plan(xMax, yMax, zMax, FFTW_BACKWARD,
			 FFTW_MEASURE | FFTW_IN_PLACE | FFTW_USE_WISDOM);
  //shift3D(x, xMax, yMax, zMax);
  fftwnd_one(myplan, (fftw_complex*)x, NULL);
  //  dword vsize = xMax * yMax * zMax;
  //  for(dword i = 0; i < vsize * 2; i++)
  //  x[i] /= (t_data)vsize;
  shift3D(x, xMax, yMax, zMax);
  fftwnd_destroy_plan(myplan);
}

t_data eval_f_c(t_data x)
{
  if(!((x >=0 && x <= 1)))
    cout << "Invalid x value: " << x << endl << flush;

  return x;
  
  if(x <= .5)
    return x;
  else
    return 1.0 - x;
  
  //  return sin(x * M_PI - M_PI/2.0);
}

t_data eval_f_r(t_data x)
{
  return .0f;
}

t_data rfilter(t_data r, t_data c, t_data x)
{
  x = x/(t_data)g_x3d;// - M_PI;
  t_data cf = eval_f_c(x);
  t_data rf = eval_f_r(x);
  return r * rf - c * cf;
}

t_data cfilter(t_data r, t_data c, t_data x)
{
  x = x/(t_data)g_x3d;// - M_PI;
  t_data cf = eval_f_c(x);
  t_data rf = eval_f_r(x);
  return rf * c + cf * r;
}
/**
 * Sphere 64^3 = .0000008
 * UNCBrain 128^3 = .000001
 */
t_data roundThings(t_data value)
{
  return value;//fabs(value)<0.000001?0.0f:value;
}

vuVector* computeGradient(t_data* volume)
{
  //  fftwnd_plan p = fftw3d_create_plan(64, 64, 64, FFTW_FORWARD, FFTW_USE_WISDOM);
  t_data *tv = new t_data[g_x3d * g_y3d * g_z3d * 2];

  vuVector *v = new vuVector[g_x3d * g_y3d * g_z3d];
  cout << "Computing X Component of frequency moment..." << flush;
  //create Wx; X component of frequency moment
  //memcpy(&tv[0], &volume[0], g_x3d * g_y3d * g_z3d * 2 * sizeof(t_data));

  for (dword i = 0; i < g_x3d; i++)
    for(dword j = 0; j < g_y3d; j++)
      for(dword k = 0; k < g_z3d; k++)
	{
	  t_data x = (t_data)i;
	  t_data r = volume[vcoord(i,j,k)];
	  t_data c = volume[vcoord(i,j,k) + 1];
	  tv[vcoord(i,j,k)] = rfilter(r, c, x);
	  tv[vcoord(i,j,k) + 1] = cfilter(r, c, x);
	}

  doStuff(tv, g_x3d, g_y3d, g_z3d);

  //cout << "Done with FFT" << flush;
  for (dword i = 0; i < g_x3d; i++)
    for(dword j = 0; j < g_y3d; j++)
      for(dword k = 0; k < g_z3d; k++)
	v[vcoord(i,j,k)/2][0] = roundThings(tv[vcoord(i,j,k)]);

  cout << "Done.\n" << flush;


  cout << "Computing Y Component of frequency moment..." << flush;
  //create Wy; Y component of frequency moment
  //memcpy(&tv[0], &volume[0], g_x3d * g_y3d * g_z3d * 2 * sizeof(t_data));
  for (dword i = 0; i < g_x3d; i++)
    for(dword j = 0; j < g_y3d; j++)
      for(dword k = 0; k < g_z3d; k++)
	{
	  t_data x = (t_data)j;
	  t_data r = volume[vcoord(i,j,k)];
	  t_data c = volume[vcoord(i,j,k) + 1];
	  tv[vcoord(i,j,k)] = rfilter(r, c, x);
	  tv[vcoord(i,j,k) + 1] = cfilter(r, c, x);
	}
  doStuff(tv, g_x3d, g_y3d, g_z3d);


  for (dword i = 0; i < g_x3d; i++)
    for(dword j = 0; j < g_y3d; j++)
      for(dword k = 0; k < g_z3d; k++)
	v[vcoord(i,j,k)/2][1] = roundThings(tv[vcoord(i,j,k)]);

  cout << "Done.\n" << flush;

  cout << "Computing Z Component of frequency moment..." << flush;
  //create Wz; Z component of frequency moment
  //memcpy(&tv[0], &volume[0], g_x3d * g_y3d * g_z3d * 2 * sizeof(t_data));
  for (dword i = 0; i < g_x3d; i++)
    for(dword j = 0; j < g_y3d; j++)
      for(dword k = 0; k < g_z3d; k++)
	{
	  t_data x = (t_data)k;
	  t_data r = volume[vcoord(i,j,k)];
	  t_data c = volume[vcoord(i,j,k) + 1];
	  tv[vcoord(i,j,k)] = rfilter(r, c, x);
	  tv[vcoord(i,j,k) + 1] = cfilter(r, c, x);
	}

  doStuff(tv, g_x3d, g_y3d, g_z3d);

  for (dword i = 0; i < g_x3d; i++)
    for(dword j = 0; j < g_y3d; j++)
      for(dword k = 0; k < g_z3d; k++)
	v[vcoord(i,j,k)/2][2] = roundThings(tv[vcoord(i,j,k)]);

  cout << "Done.\n" << flush;


  delete tv;
  return v;
}

} // NS_END
