/*
  Copyright (c) 2002 Tai Meng (tmeng@sfu.ca). All Rights Reserved
*/ 

/*============================================================*/

/*
  Created on August 11 2002 (Revision 1)
 */

/*============================================================*/

/*
  Revision History:

  Revision 2:
*/

/*============================================================*/

/* 
  To-Do List:
   
*/

/*============================================================*/

/*
  Q & A
*/

/*============================================================*/

/*
  Mini-discoveries
*/

/*============================================================*/

/*
  Modifications to other vuVolume classes:

*/

/*============================================================*/

#ifndef _VU_GRID_H_
#define _VU_GRID_H_

/*============================================================*/

#include <ostream.h> //ostream doesn't exist, must have .h

/*============================================================*/

using namespace std; //this avoid naming conflicts among globals

/*============================================================*/
/* Doxygen tags are marked by the special "!" symbols after */
/* comments i.e. "//!" NOTE: I used Qt-style comments */
/*============================================================*/

//! This class models a grid
/*! 
*/

class vuGrid
{
 private:

  /*============================================================*/
  /* PRIVATE ATTRIBUTES */
  /*============================================================*/
 
  //!
  /*!
  */
  float xWidth;

  /*============================================================*/
 
  //!
  /*!
  */
  float yHeight;

  /*============================================================*/
 
  //!
  /*!
  */
  float zDepth;

  /*============================================================*/
 
  //!
  /*!
  */
  bool isDrawGrid;

  /*============================================================*/
  /* PRIVATE MEMBER FUNCTIONS */
  /*============================================================*/

 public:
  
  /*============================================================*/
  /* CONSTRUCTORS */
  /*============================================================*/
 
  //! Default constructor.
  /*! 
   */
  vuGrid();

  /*============================================================*/

  //! Copy contructor.
  /*! 
  */
  vuGrid(const vuGrid& v);

  /*============================================================*/

  //! Constructor taking in member info
  /*! 
  */
  vuGrid(float width, float height, float depth);

  /*============================================================*/

  //! Constructor taking in member info
  /*! 
  */
  vuGrid(float width, float height, float depth, bool isGrid);

  /*============================================================*/

  //! The destructor.
  /*!
   */
  ~vuGrid();

  /*============================================================*/
  /* MUTATORS */
  /*============================================================*/
  
  //! The assignment operator.
  /*!
   */
  vuGrid& operator=(const vuGrid& v);

  /*============================================================*/
  
  //! Enables grid
  /*!
   */
  void enable();

  /*============================================================*/
  
  //! Disables grid
  /*!
   */
  void disable();

  /*============================================================*/
  
  //! Toggles grid enable
  /*!
   */
  void toggle();

  /*============================================================*/
  /* ACCESSORS */
  /*============================================================*/
 
  //! 
  /*!
   */
  float getWidth() const;

  /*============================================================*/
 
  //! 
  /*!
   */
  float getHeight() const;

  /*============================================================*/
 
  //! 
  /*!
   */
  float getDepth() const;

  /*============================================================*/
 
  //! 
  /*!
   */
  bool getStatus() const;

  /*============================================================*/
 
  //! 
  /*!
   */
  float getCenterX() const;

  /*============================================================*/
 
  //! 
  /*!
   */
  float getCenterY() const;

  /*============================================================*/
 
  //! 
  /*!
   */
  float getCenterZ() const;

  /*============================================================*/
 
  //! Equality comparison.
  /*!
   */
  bool operator==(const vuGrid& v) const;

  /*============================================================*/

  //! Inequality comparison. 
  /*!
   */
  bool operator!=(const vuGrid& v) const;

  /*============================================================*/

  //! 
  /*!
   */
  void drawLine(vuVector& start, vuVector& end) const;

  /*============================================================*/

  //! Labels the x, y, z axes
  /*!
   */
  void labelAxes() const;
  
  /*============================================================*/

  //! Draws the x, y, z axes
  /*!
   */
  void drawAxes() const;
  
  /*============================================================*/

  //! Draws the object in OpenGL.
  /*!
    Note that the proper GL initialization function calls must be
    made before this function is called. For some tutorials on
    programming with OpenGL, visit nehe.gamedev.net.
  */
  void drawInOpenGL() const;

  /*============================================================*/
  /* Friend Functions */
  /*============================================================*/

  //! Redefines the << (insertion) operator
  /*!
   */
  friend ostream& operator<<(ostream& out, const vuGrid& t);
};

/*============================================================*/

typedef vuGrid* vuGridPointer;
typedef vuGridPointer* vuGridPointerArray;

#endif
