#ifndef _VUVOLUMEREGULARUNIMODAL3D1B_H_
#define _VUVOLUMEREGULARUNIMODAL3D1B_H_
/*! \todo Consider to make generateLapWeightHistogram() a
    friend function and integrate it with the vuHistogram class.
*/

#include "../3d.h"

class vu11121;
typedef vu11121 vuVolumeRegularUnimodal3d1B;

class vuConvert;

//!The base class for regular unimodal 3d 1 byte data in the vuVolume data tree.
class vu11121 : public vu1112
{
    friend class vuConvert;
public:
    vu11121();
    vu11121(byte *data, dword XSize, dword YSize, dword ZSize);
    //!Reads volume data from the data file set with setFileName().
    /*!This implements the abstract read() method from the general Volume class.
       If the read is successful, the function returns true.  If the file does
       not exist or is in an invalid format, the function returns false.  In
       this case, the error information is set for the instance.
       \return True if successful, false otherwise.
    */
    virtual bool read(void);
    //!Writes volume data to the data file set with setFileName().
    /*!This implements the abstract write() method from the general Volume class.
       \return True if successful, false otherwise.
    */
    virtual bool write(void);

    /*!laplacian weighted histogram and isosurface area
      see V.Pekar, R.Wienker, D.Hempel, "Fast Detection of Meaningful
      Isosurfaces for Volume Data Visualization", in Proccedings of
      IEEE Visualization 2001
    */
    void generateLapWeightHistogram();

    //! returns the value at position x,y,z
    byte getDataValue(unsigned int x, unsigned int y, unsigned int z) const {
	if ( (x<0) || (x>=m_Dim1Size) || (y<0) || (y>=m_Dim2Size) || (z<0) || (z>=m_Dim3Size) )
	    return 0;
	else
	    return m_Data[x+y*m_Dim1Size+z*m_Dim1Size*m_Dim2Size];
    }

    //!Empty implementation to satisfy virtual.
    void setViewVectors (const vuVector &, const vuVector &, const vuVector &) {};
    //!Empty implementation to satisfy virtual.
    void render() {};
    
    /** Removes some parts of the volume.
	cube[1..6] are x0, x1, y0, y1, z0, and z1 */
    void cropFrom(const vu11121& vol, word cube[6]);
    /** Creates this volume as a scaled version of vol. 
	Currently this function is using nearest neighbour interpolation :-(
     */
    void scaleFrom(const vu11121& vol, word nx, word ny, word nz);

    /**A friend to read the RAW format
       First line is ascii SIZEX SIZEY SIZEZ [PNTSIZE=1].
       m_DataSize will be set in vu1112,      */
    friend bool readRAW(const vuString& fname, vu11121& vol);

    /** Creates a histogram in hist.
	This is just a preliminary version of histogram creation. See
	class vuHistogram for a more detailed discussion. 
	\return false - could not create histogram type
    */
    bool createHistogram(vuHistogram& hist) const;

    /** Remaps the intensities */
    void remap(const vuMap& map);

 protected:
    //!Asserts that the file is 3d data and reads the associated information.
    /*!This method reads in the general information for 3d data sets.
       It also asserts whether the data is indeed 3d or not.
       \return True if successful (data is regular), false otherwise.
    */
    bool read(FILE *file);
    //!Writes the general 3d data information to the file.
    /*!\return True if successful, false otherwise.
    */
    bool write(FILE *file);

};

#endif
