#include "1B.h"
#include <stdio.h>
#include <fstream>

using namespace std;

vu11121::vu11121() {}

vu11121::vu11121(byte *data, dword XSize, dword YSize, dword ZSize)
{
  m_Data     = data;
  m_DataSize = XSize * YSize * ZSize;
  m_Dim1Size = XSize;
  m_Dim2Size = YSize;
  m_Dim3Size = ZSize;
}

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu11121::read(void)
{
    if (m_FileName.isEmpty()) return setError("No file name specified.");
    
    FILE *file = fopen(m_FileName,"rb");
    if (file != NULL)
    {
        bool success = read(file);
        fclose(file);
        return success;
    }
    else
        return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- public write() -----------------------------------
//----------------------------------------------------------------------------

bool vu11121::write(void)
{
    if (m_FileName.isEmpty()) return setError("No file name specified.");
    
    FILE *file = fopen(m_FileName,"wb");
    if (file != NULL)
    {
        bool success = write(file);
        fclose(file);
        return success;
    }
    else
        return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu11121::read(FILE *file)
{
    int ret = 0;
    dword size = 0;
    int len = 0;

    //Read in the base data.
    bool success = vu1112::read(file);
    if (!success) return false;

    //Read in the name of the data
    char dataName[64];
    ret = fscanf(file,"SCALARS %s ",dataName);
    if (ret != 1) return setInvalidFormatError();
    //Store the name of the data
    m_DataName = dataName;

    //Read in the type of data and the colour lookup table.
    fscanf(file,"byte LOOKUP_TABLE default%n",&len);
    if ((len < 25) || (fgetc(file) != '\n')) return setInvalidFormatError();

    //check data size
    if (m_DataSize != (m_Dim1Size * m_Dim2Size * m_Dim3Size))
        return setInvalidFormatError();

    //Allocate memory for the volume data
    m_Data = new byte[m_DataSize];

    //Read in the volume data according to the format of the file
    if (m_Binary)
        size = fread(m_Data,sizeof(byte),m_DataSize,file);
    else
    {
        ret = 1;
        dword i = 0;
        while ((ret > 0) && (i < m_DataSize))
            ret = fscanf(file," %c",&m_Data[i++]);
        size = i;
    }
    
    //Make sure that the right amount of data was read in
    if (size != m_DataSize) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu11121::write(FILE *file)
{
    int ret;
    dword size = 0;

    m_Binary = true;

    bool success = vu1112::write(file);
    if (!success) return false;
    
    fprintf(file,"SCALARS ");

    //Write the name of the data
    if (!m_DataName.isEmpty())
        fprintf(file,"%s ",m_DataName.c_str());
    else
        fprintf(file,"data ");

    fprintf(file,"byte\nLOOKUP_TABLE default\n");

    //Write the volume data according to it's format
    if (m_Binary)
        size = fwrite(m_Data,sizeof(byte),m_DataSize,file);
    else
    {
        ret = 1;
        dword i = 0;
        while ((ret > 0) && (i < m_DataSize))
            ret = fprintf(file," %d",m_Data[i++]);
        size = i;
    }
    
    if (size == m_DataSize)
        return true;
    else
        return setWriteError();
}

void vu11121::generateLapWeightHistogram()
{
    /*!laplacian weighted histogram and isosurface area
      see V.Pekar, R.Wienker, D.Hempel, "Fast Detection of Meaningful
      Isosurfaces for Volume Data Visualization", in Proccedings of
      IEEE Visualization 2001
    */

    unsigned long laplace_hist[256];
    unsigned long surface_area[256];
    //
    // generate laplacian weighted histogram
    //

    for (int i=0; i<256; i++)
      {
	laplace_hist[i] = 0;
	surface_area[i] = 0;
      }

    for (unsigned int k=0; k<m_Dim3Size; k++)
      for (unsigned int j=0; j<m_Dim2Size; j++)
	for (unsigned int i=0; i<m_Dim1Size; i++)
	  {
	    unsigned int val = getDataValue(i,j,k);
	    
	    laplace_hist[val] +=
	      ((getDataValue(i, j , k) - getDataValue(i+2, j, k)) - (getDataValue(i-2, j , k) - getDataValue(i, j, k))) +
	      ((getDataValue(i, j , k) - getDataValue(i, j+2, k)) - (getDataValue(i, j-2 , k) - getDataValue(i, j, k))) +
	      ((getDataValue(i, j , k) - getDataValue(i, j, k+2)) - (getDataValue(i, j , k-2) - getDataValue(i, j, k)));

	      if (val > getDataValue(i+1,j,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i+1,j,k))
		surface_area[val] -= 1;
	      if (val > getDataValue(i-1,j,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i-1,j,k))
		surface_area[val] -= 1;

	      if (val > getDataValue(i,j+1,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j+1,k))
		surface_area[val] -= 1;
	      if (val > getDataValue(i,j-1,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j-1,k))
		surface_area[val] -= 1;

	      if (val > getDataValue(i,j,k+1))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j,k+1))
		surface_area[val] -= 1;
	      if (val > getDataValue(i,j,k-1))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j,k-1))
		surface_area[val] -= 1;
	  }

    for (int i = 254; i>= 0; i--)
      {
	laplace_hist[i] += laplace_hist[i+1];
	surface_area[i] += surface_area[i+1];
      }

    cout << "Writing laplacian weighted histogram to file..." << endl;

    FILE *fp1, *fp2;
    
    fp1=fopen("lp_hist.dat","w");
    fp2=fopen("lp_area_hist.dat","w");
    
    // write header
    for (int i=0; i<256; i++)
      {
	fprintf(fp1, "%d %d\n", i, (int)laplace_hist[i]);
	if (surface_area[i] != 0)
	  fprintf(fp2, "%d %f\n", i, double(laplace_hist[i])/double(surface_area[i]));
      }
	
    fclose(fp1);
    fclose(fp2);

}

void vu11121::cropFrom(const vu11121& vol, word cube[6])
{
    if(cube[1]>vol.m_Dim1Size) cube[1] = vol.m_Dim1Size;
    if(cube[3]>vol.m_Dim2Size) cube[3] = vol.m_Dim2Size;
    if(cube[5]>vol.m_Dim3Size) cube[5] = vol.m_Dim3Size;
    if(cube[0]<cube[1] &&
       cube[2]<cube[3] &&
       cube[4]<cube[5] )
    {
	operator=(vol);		// copy all stuff
	if(m_Data) {
	    delete [] m_Data;
	    m_Data = NULL;
	}
	m_Dim1Size = cube[1] - cube[0];
	m_Dim2Size = cube[3] - cube[2];
	m_Dim3Size = cube[5] - cube[4];
	m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;
	m_Data = new byte[m_DataSize];
	dword i,j,k;
	dword srclayer = vol.m_Dim1Size*vol.m_Dim2Size;
	dword layer = m_Dim1Size*m_Dim2Size;
	dword offset = srclayer*cube[4] + vol.m_Dim1Size*cube[2] + cube[0];
	for(k=0; k<m_Dim3Size; k++)
	    for(j=0; j<m_Dim2Size; j++)
	    {
		const byte *src = &vol.m_Data[
		    srclayer*k + vol.m_Dim1Size*j + offset];
		byte *dst = &m_Data[layer*k + m_Dim1Size*j];
		for(i=0; i<m_Dim1Size; i++, src++, dst++)
		{
		    *dst = *src;
		}
	    }
    }
}

void vu11121::scaleFrom(const vu11121& vol, word nx, word ny, word nz)
{
    operator=(vol);		// copy all stuff
    //This is just to make the current crapy implementation easier...
    m_Dim1Size = nx;
    m_Dim2Size = ny;
    m_Dim3Size = nz;
    if(m_Data) {
	delete [] m_Data;
	m_Data = NULL;
    }
    m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;
    m_Data = new byte[m_DataSize];
    dword i,j,k;
    dword layer = m_Dim1Size*m_Dim2Size;
    for(k=0; k<m_Dim3Size; k++)
	for(j=0; j<m_Dim2Size; j++)
	{
	    byte *dst = &m_Data[layer*k + m_Dim1Size*j];
	    for(i=0; i<m_Dim1Size; i++, dst++)
	    {
		//for correct rescaling a an interpolating method should
		//be used with floating point position
		//kind of:
		//getInterpolatedValue((float)i*vol.m_Dim1Size/m_Dim1Size,
		//			(float)j*vol.m_Dim2Size/m_Dim2Size,
		//			(float)k*vol.m_Dim3Size/m_Dim3Size);
		//for scaling down we need to integrate

		*dst = vol.getDataValue(i*vol.m_Dim1Size/m_Dim1Size,
					j*vol.m_Dim2Size/m_Dim2Size,
					k*vol.m_Dim3Size/m_Dim3Size);
	    }
	}
}

bool readRAW(const vuString& fname, vu11121& vol)
{
    ifstream vf(fname);
    if(!vf.good()) return false;
    char line[2048];
    vf.getline(line, 2047, 0x20);
    if(sscanf(line, "%lu", &vol.m_Dim1Size) != 1)
	return false;
    vf.getline(line, 2047, 0x20);
    if(sscanf(line, "%lu", &vol.m_Dim2Size) != 1)
	return false;
    vf.getline(line, 2047, 0x20);
    if(sscanf(line, "%lu", &vol.m_Dim3Size) != 1)
	return false;
    //int pntsize = 1;
    //vf.getline(line, 2047, 0x20);
    //if(sscanf(line, "%lu", &pntsize) != 1)
    //return false;
    //DEBUG << vf.tellg() << endl;
    
    if(vol.m_Data) delete [] vol.m_Data;
    vol.m_DataSize = vol.m_Dim1Size*vol.m_Dim2Size*vol.m_Dim3Size;
    vol.m_Data = new byte[vol.m_DataSize];
    
    vf.read((char *)vol.m_Data, (int)vol.m_DataSize);
    if(vf.gcount() != (long)vol.m_DataSize || vf.bad()) 
    {
	cout << "gcount=" << vf.gcount() << "  m_DataSize=" << vol.m_DataSize
	     << "  bad=" << (vf.bad()?"on":"off")
	     << "eof" << (vf.eof() ? "on" : "off") << endl;
	return false;
    }

    return true;
}

bool vu11121::createHistogram(vuHistogram& hist) const
{
    if(hist.getType() == vuHistogram::TYPE_INTENSITY) {
	hist.reset();
	const byte *dat = m_Data;
	dword p;
	for(p=0; p<m_Dim1Size*m_Dim2Size*m_Dim3Size; p++, dat++)
	    hist.recordIntensity(*dat);
	return true;
    } else return false;
}

void vu11121::remap(const vuMap& map)
{
    dword i;
    byte *dat = m_Data;
    for(i=m_Dim1Size*m_Dim2Size*m_Dim3Size; i>0; i--, dat++)
	*dat = map[*dat];
}
